/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.nuget.metadata;

import com.artipie.nuget.metadata.Nuspec;
import com.artipie.nuget.metadata.OptFieldName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public interface CatalogEntry {
    public JsonObject asJson();

    public static final class FromNuspec
    implements CatalogEntry {
        private static final String AUTHORS_FIELD = "authors";
        private final Nuspec nuspec;

        public FromNuspec(Nuspec nuspec) {
            this.nuspec = nuspec;
        }

        @Override
        public JsonObject asJson() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("@id", "null");
            builder.add("id", this.nuspec.id().raw());
            builder.add("version", this.nuspec.version().raw());
            builder.add("description", this.nuspec.description());
            String authors = this.nuspec.authors();
            if (authors.contains(",")) {
                JsonArrayBuilder arr = Json.createArrayBuilder();
                Arrays.stream(authors.split(",")).forEach(item -> arr.add(item.trim()));
                builder.add(AUTHORS_FIELD, arr);
            } else {
                builder.add(AUTHORS_FIELD, authors);
            }
            builder.add("dependencyGroups", this.dependencyGroupArray());
            this.addOptFields(builder);
            return builder.build();
        }

        private void addOptFields(JsonObjectBuilder builder) {
            this.nuspec.minClientVersion().ifPresent(min -> builder.add("minClientVersion", min));
            this.addOneOfTwo(builder, OptFieldName.LICENSE, OptFieldName.LICENSE_URL);
            this.addOneOfTwo(builder, OptFieldName.ICON, OptFieldName.ICON_URL);
            Stream.of(OptFieldName.PROJECT_URL, OptFieldName.REQUIRE_LICENSE_ACCEPTANCE, OptFieldName.TITLE, OptFieldName.SUMMARY).forEach(item -> this.nuspec.fieldByName((OptFieldName)((Object)item)).ifPresent(val -> builder.add(item.get(), val)));
            this.nuspec.fieldByName(OptFieldName.TAGS).ifPresent(val -> {
                if (val.contains(" ")) {
                    JsonArrayBuilder arr = Json.createArrayBuilder();
                    Stream.of(val.split(" ")).forEach(arg_0 -> ((JsonArrayBuilder)arr).add(arg_0));
                    builder.add(OptFieldName.TAGS.get(), arr);
                } else {
                    builder.add(OptFieldName.TAGS.get(), val);
                }
            });
        }

        private void addOneOfTwo(JsonObjectBuilder builder, OptFieldName first, OptFieldName second) {
            Stream.of(this.nuspec.fieldByName(first), this.nuspec.fieldByName(second)).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(lc -> builder.add(second.get(), lc));
        }

        private JsonArrayBuilder dependencyGroupArray() {
            JsonArrayBuilder groups = Json.createArrayBuilder();
            this.dependenciesByTargetFramework().forEach((key, val) -> {
                JsonObjectBuilder item = Json.createObjectBuilder();
                if (!key.isEmpty()) {
                    item.add("targetFramework", key);
                }
                JsonArrayBuilder deps = Json.createArrayBuilder();
                val.forEach(pair -> {
                    JsonObjectBuilder dep = Json.createObjectBuilder();
                    dep.add("id", (String)pair.getKey());
                    if (!((String)pair.getValue()).isEmpty()) {
                        dep.add("range", String.format("[%s, )", pair.getValue()));
                    }
                    deps.add(dep);
                });
                groups.add(item.add("dependencies", deps));
            });
            return groups;
        }

        private Map<String, List<Pair<String, String>>> dependenciesByTargetFramework() {
            HashMap<String, List<Pair<String, String>>> res = new HashMap<String, List<Pair<String, String>>>();
            this.nuspec.dependencies().forEach(item -> {
                List dep;
                String[] arr = item.split(":");
                if (arr[0].isEmpty()) {
                    dep = Collections.emptyList();
                } else {
                    dep = new ArrayList(12);
                    dep.add(new ImmutablePair((Object)arr[0], (Object)arr[1]));
                }
                String framework = arr.length == 3 ? arr[2] : "";
                res.merge(framework, dep, (existing, adding) -> {
                    existing.addAll(adding);
                    return existing;
                });
            });
            return res;
        }
    }
}

