/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core;

import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.PrintStream;

public abstract class Aspectran {
    public static final String VERSION;
    public static final String POWERED_BY;
    public static final String POWERED_BY_LINK;
    public static final boolean STABLE;

    public static String getVersion() {
        return VERSION;
    }

    public static String getPoweredBy() {
        return POWERED_BY;
    }

    public static String getPoweredByLink() {
        return POWERED_BY_LINK;
    }

    public static void printAboutMe(PrintStream output) {
        Assert.notNull((Object)output, "output must not be null");
        output.println("Aspectran: " + VERSION);
        output.println("JVM: " + System.getProperty("java.vm.name") + " (build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")");
        output.println("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
    }

    public static void printPrettyAboutMe(@NonNull PrintStream output) {
        Assert.notNull((Object)output, "output must not be null");
        output.println("---------------------------------------------------------------------");
        output.printf(" %1$-9s : %2$s%n", "Aspectran", VERSION);
        output.printf(" %1$-9s : %2$s%n", "JVM", System.getProperty("java.vm.name") + " (build " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.info") + ")");
        output.printf(" %1$-9s : %2$s%n", "OS", System.getProperty("os.name") + " " + System.getProperty("os.version") + " " + System.getProperty("os.arch"));
        output.println("---------------------------------------------------------------------");
    }

    public static void main(String[] args) {
        Aspectran.printPrettyAboutMe(System.out);
    }

    static {
        Package pkg = Aspectran.class.getPackage();
        VERSION = pkg != null && "The Aspectran Project".equals(pkg.getImplementationVendor()) && pkg.getImplementationVersion() != null ? pkg.getImplementationVersion() : System.getProperty("aspectran.version", "8.2.x");
        POWERED_BY = "Powered by Aspectran " + VERSION;
        POWERED_BY_LINK = "<a href=\"https://aspectran.com\">Powered by Aspectran " + VERSION + "</a>";
        STABLE = !VERSION.matches("^.*\\.(RC|M)[0-9]+$");
    }
}

