/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityStringifyContext;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.asel.item.ItemEvaluation;
import com.aspectran.core.context.asel.item.ItemEvaluator;
import com.aspectran.core.context.asel.token.TokenEvaluation;
import com.aspectran.core.context.asel.token.TokenEvaluator;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractActivity
implements Activity {
    private final ActivityContext context;
    private Activity parentActivity;
    private SessionAdapter sessionAdapter;
    private RequestAdapter requestAdapter;
    private ResponseAdapter responseAdapter;
    private Throwable raisedException;
    private Map<String, Object> settings;
    private StringifyContext stringifyContext;
    private TokenEvaluator tokenEvaluator;
    private ItemEvaluator itemEvaluator;

    protected AbstractActivity(@NonNull ActivityContext context) {
        this.context = context;
    }

    @Override
    public Activity.Mode getMode() {
        return Activity.Mode.DEFAULT;
    }

    @Override
    public ActivityContext getActivityContext() {
        return this.context;
    }

    @Override
    public ClassLoader getClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = this.context.getClassLoader();
        }
        return cl;
    }

    @Override
    public Environment getEnvironment() {
        return this.context.getEnvironment();
    }

    protected Activity getCurrentActivity() {
        return this.context.getCurrentActivity();
    }

    protected void saveCurrentActivity() {
        if (this.context.hasCurrentActivity()) {
            this.parentActivity = this.context.getCurrentActivity();
        }
        this.context.setCurrentActivity(this);
    }

    protected void removeCurrentActivity() {
        if (this.parentActivity != null) {
            this.context.setCurrentActivity(this.parentActivity);
        } else {
            this.context.removeCurrentActivity();
        }
    }

    protected <V extends Activity> V getParentActivity() {
        return (V)this.parentActivity;
    }

    protected boolean hasParentActivity() {
        return this.parentActivity != null;
    }

    @Override
    public ApplicationAdapter getApplicationAdapter() {
        return this.context.getApplicationAdapter();
    }

    @Override
    public SessionAdapter getSessionAdapter() {
        return this.sessionAdapter;
    }

    protected void setSessionAdapter(SessionAdapter sessionAdapter) {
        this.sessionAdapter = sessionAdapter;
    }

    @Override
    public RequestAdapter getRequestAdapter() {
        return this.requestAdapter;
    }

    protected void setRequestAdapter(RequestAdapter requestAdapter) {
        this.requestAdapter = requestAdapter;
    }

    @Override
    public ResponseAdapter getResponseAdapter() {
        return this.responseAdapter;
    }

    protected void setResponseAdapter(ResponseAdapter responseAdapter) {
        this.responseAdapter = responseAdapter;
    }

    @Override
    public boolean isExceptionRaised() {
        return this.raisedException != null;
    }

    @Override
    public Throwable getRaisedException() {
        return this.raisedException;
    }

    @Override
    public Throwable getRootCauseOfRaisedException() {
        if (this.raisedException != null) {
            return ExceptionUtils.getRootCause(this.raisedException);
        }
        return null;
    }

    @Override
    public void setRaisedException(Throwable raisedException) {
        if (this.raisedException == null) {
            this.raisedException = raisedException;
        }
    }

    @Override
    public void clearRaisedException() {
        this.raisedException = null;
    }

    @Override
    public void terminate() throws ActivityTerminatedException {
        this.terminate("Explicitly terminated by calling terminate()");
    }

    @Override
    public void terminate(String cause) throws ActivityTerminatedException {
        throw new ActivityTerminatedException(cause);
    }

    @Override
    public <V> V getSetting(String name) {
        Object value;
        if (this.settings != null && (value = this.settings.get(name)) != null) {
            return (V)value;
        }
        return null;
    }

    @Override
    public void putSetting(String name, Object value) {
        if (StringUtils.isEmpty(name)) {
            throw new IllegalArgumentException("Setting name must not be null or empty");
        }
        if (this.settings == null) {
            this.settings = new LinkedHashMap<String, Object>();
        }
        this.settings.put(name, value);
    }

    @Override
    public StringifyContext getStringifyContext() {
        if (this.stringifyContext == null) {
            this.stringifyContext = new ActivityStringifyContext(this);
        }
        return this.stringifyContext;
    }

    @Override
    public TemplateRenderer getTemplateRenderer() {
        return this.context.getTemplateRenderer();
    }

    @Override
    public TokenEvaluator getTokenEvaluator() {
        if (this.tokenEvaluator == null) {
            this.tokenEvaluator = new TokenEvaluation(this);
        }
        return this.tokenEvaluator;
    }

    @Override
    public ItemEvaluator getItemEvaluator() {
        if (this.itemEvaluator == null) {
            this.itemEvaluator = new ItemEvaluation(this.getTokenEvaluator());
        }
        return this.itemEvaluator;
    }

    @Override
    public <V> V getBean(String id) {
        return this.context.getBeanRegistry().getBean(id);
    }

    @Override
    public <V> V getBean(Class<V> type) {
        return this.context.getBeanRegistry().getBean(type);
    }

    @Override
    public <V> V getBean(Class<V> type, String id) {
        return this.context.getBeanRegistry().getBean(type, id);
    }

    @Override
    public <V> V getPrototypeScopeBean(BeanRule beanRule) {
        return this.context.getBeanRegistry().getPrototypeScopeBean(beanRule);
    }

    @Override
    public boolean containsBean(String id) {
        return this.context.getBeanRegistry().containsBean(id);
    }

    @Override
    public boolean containsBean(Class<?> type) {
        return this.context.getBeanRegistry().containsBean(type);
    }

    @Override
    public boolean containsBean(Class<?> type, String id) {
        return this.context.getBeanRegistry().containsBean(type, id);
    }
}

