/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public class ActivityStringifyContext
extends StringifyContext {
    private static final Logger logger = LoggerFactory.getLogger(ActivityStringifyContext.class);
    static final int MAX_INDENT_SIZE = 8;
    public static final String FORMAT_PRETTY = "format.pretty";
    public static final String FORMAT_INDENT_STYLE = "format.indentStyle";
    private static final String FORMAT_INDENT_STYLE_TAB = "tab";
    public static final String FORMAT_INDENT_SIZE = "format.indentSize";
    public static final String FORMAT_NULL_WRITABLE = "format.nullWritable";
    public static final String FORMAT_DATETIME_FORMAT = "format.dateTimeFormat";
    public static final String FORMAT_DATE_FORMAT = "format.dateFormat";
    public static final String FORMAT_TIME_FORMAT = "format.timeFormat";

    ActivityStringifyContext(@NonNull Activity activity) {
        String indentStyle = (String)activity.getSetting(FORMAT_INDENT_STYLE);
        String dateTimeFormat = (String)activity.getSetting(FORMAT_DATETIME_FORMAT);
        String dateFormat = (String)activity.getSetting(FORMAT_DATE_FORMAT);
        String timeFormat = (String)activity.getSetting(FORMAT_TIME_FORMAT);
        Object pretty = activity.getSetting(FORMAT_PRETTY);
        Boolean prettyToUse = null;
        if (pretty instanceof Boolean) {
            Boolean prettyInBool;
            prettyToUse = prettyInBool = (Boolean)pretty;
        } else if (pretty != null) {
            prettyToUse = BooleanUtils.toBooleanObject(pretty.toString());
        }
        Object indentSize = activity.getSetting(FORMAT_INDENT_SIZE);
        int indentSizeToUse = 0;
        if (indentSize instanceof Number) {
            Number number = (Number)indentSize;
            indentSizeToUse = number.intValue();
        } else if (indentSize != null) {
            indentSizeToUse = ActivityStringifyContext.parseIndentSize(indentSize.toString());
        }
        Object nullWritable = activity.getSetting(FORMAT_NULL_WRITABLE);
        Boolean nullWritableToUse = null;
        if (nullWritable instanceof Boolean) {
            Boolean nullWritableInBool;
            nullWritableToUse = nullWritableInBool = (Boolean)nullWritable;
        } else if (nullWritable != null) {
            nullWritableToUse = BooleanUtils.toBooleanObject(nullWritable.toString());
        }
        if (FORMAT_INDENT_STYLE_TAB.equalsIgnoreCase(indentStyle)) {
            this.setIndentTab(true);
            this.setIndentSize(1);
        } else if (indentSizeToUse > 0) {
            this.setIndentSize(indentSizeToUse);
        }
        if (prettyToUse != null) {
            this.setPretty(prettyToUse);
        } else if (this.getIndentSize() > 0) {
            this.setPretty(true);
        }
        if (nullWritableToUse != null) {
            this.setNullWritable(nullWritableToUse);
        }
        if (StringUtils.hasLength(dateTimeFormat)) {
            this.setDateTimeFormat(dateTimeFormat);
        }
        if (StringUtils.hasLength(dateFormat)) {
            this.setDateFormat(dateFormat);
        }
        if (StringUtils.hasLength(timeFormat)) {
            this.setTimeFormat(timeFormat);
        }
        if (activity.getRequestAdapter() != null) {
            this.setLocale(activity.getRequestAdapter().getLocale());
        }
    }

    private static int parseIndentSize(String indentSize) {
        try {
            int size = Integer.parseInt(indentSize);
            if (size > 8) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Indent size should be less than 8");
                }
                size = 8;
            }
            return size;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }
}

