/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.AbstractActivity;
import com.aspectran.core.activity.aspect.AdviceConstraintViolationException;
import com.aspectran.core.activity.aspect.AspectAdviceException;
import com.aspectran.core.activity.aspect.AspectAdviceResult;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.component.aspect.AspectAdviceRulePostRegister;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.asel.token.TokenEvaluator;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AdviceActivity
extends AbstractActivity {
    private static final Logger logger = LoggerFactory.getLogger(AdviceActivity.class);
    private AspectAdviceRuleRegistry aspectAdviceRuleRegistry;
    private Set<AspectRule> relevantAspectRules;
    private Set<AspectAdviceRule> executedAdviceRules;
    private AspectAdviceType currentAdviceType;
    private AspectAdviceRule currentAdviceRule;
    private AspectAdviceResult aspectAdviceResult;

    public AdviceActivity(ActivityContext context) {
        super(context);
    }

    @Override
    public <V> V getSetting(String name) {
        Object value = super.getSetting(name);
        if (value != null) {
            return value;
        }
        if (this.aspectAdviceRuleRegistry != null && this.aspectAdviceRuleRegistry.getSettingsAdviceRuleList() != null) {
            for (SettingsAdviceRule settingsAdviceRule : this.aspectAdviceRuleRegistry.getSettingsAdviceRuleList()) {
                value = settingsAdviceRule.getSetting(name);
                if (value == null || !this.isAcceptable(settingsAdviceRule.getAspectRule())) continue;
                if (value instanceof String) {
                    String str = (String)value;
                    return (V)TokenEvaluator.evaluate(str, this);
                }
                return value;
            }
        }
        return null;
    }

    protected void prepareAspectAdviceRules(@NonNull TransletRule transletRule, String requestName) {
        AspectAdviceRuleRegistry aarr;
        if (transletRule.hasPathVariables() || this.getActivityContext().getAspectRuleRegistry().hasNewAspectRules()) {
            AspectAdviceRulePostRegister postRegister = new AspectAdviceRulePostRegister();
            for (AspectRule aspectRule : this.getActivityContext().getAspectRuleRegistry().getAspectRules()) {
                Pointcut pointcut;
                if (aspectRule.isBeanRelevant() || (pointcut = aspectRule.getPointcut()) != null && !pointcut.matches(requestName)) continue;
                postRegister.register(aspectRule);
            }
            aarr = postRegister.getAspectAdviceRuleRegistry();
        } else {
            aarr = transletRule.replicateAspectAdviceRuleRegistry();
        }
        if (aarr != null) {
            if (this.aspectAdviceRuleRegistry != null) {
                this.aspectAdviceRuleRegistry.merge(aarr);
            } else {
                this.aspectAdviceRuleRegistry = aarr;
            }
        }
    }

    protected void setCurrentAdviceType(AspectAdviceType aspectAdviceType) {
        this.currentAdviceType = aspectAdviceType;
    }

    @Override
    public void registerAspectAdviceRule(AspectRule aspectRule) throws AdviceConstraintViolationException, AspectAdviceException {
        block13: {
            if (this.currentAdviceType == null) {
                AdviceConstraintViolationException ex = new AdviceConstraintViolationException();
                String msg = "Advice can not be registered at an UNKNOWN activity phase";
                msg = ex.addViolation(aspectRule, msg);
                logger.error(msg);
                throw ex;
            }
            if (this.currentAdviceType == AspectAdviceType.THROWN) {
                AdviceConstraintViolationException ex = new AdviceConstraintViolationException();
                String msg = "Advice can not be registered at the THROWN activity phase";
                msg = ex.addViolation(aspectRule, msg);
                logger.error(msg);
                throw ex;
            }
            if (this.relevantAspectRules != null && this.relevantAspectRules.contains(aspectRule)) {
                return;
            }
            this.touchRelevantAspectRules().add(aspectRule);
            this.touchAspectAdviceRuleRegistry().register(aspectRule);
            List<AspectAdviceRule> aspectAdviceRuleList = aspectRule.getAspectAdviceRuleList();
            if (aspectAdviceRuleList == null) break block13;
            if (this.currentAdviceType == AspectAdviceType.FINALLY) {
                AdviceConstraintViolationException ex = null;
                for (AspectAdviceRule adviceRule : aspectAdviceRuleList) {
                    AspectAdviceType adviceType = adviceRule.getAspectAdviceType();
                    if (adviceType != AspectAdviceType.BEFORE && adviceType != AspectAdviceType.AFTER) continue;
                    if (ex == null) {
                        ex = new AdviceConstraintViolationException();
                    }
                    String msg = "BEFORE or AFTER advice should never be registered after the FINALLY activity phase";
                    if ((msg = ex.addViolation(aspectRule, msg)) == null) continue;
                    logger.error(msg);
                }
                if (ex != null) {
                    throw ex;
                }
            }
            if (this.currentAdviceRule != null) {
                AspectAdviceRule adviceRule1 = this.currentAdviceRule;
                AspectAdviceType adviceType1 = adviceRule1.getAspectAdviceType();
                for (AspectAdviceRule adviceRule2 : aspectAdviceRuleList) {
                    AspectAdviceType adviceType2 = adviceRule2.getAspectAdviceType();
                    if (adviceType1 == adviceType2) {
                        int order1 = adviceRule1.getAspectRule().getOrder();
                        int order2 = adviceRule2.getAspectRule().getOrder();
                        if (adviceType1 == AspectAdviceType.BEFORE) {
                            if (order2 >= order1) continue;
                            this.executeAdvice(adviceRule2, true);
                            continue;
                        }
                        if (order2 <= order1) continue;
                        this.executeAdvice(adviceRule2, true);
                        continue;
                    }
                    if (adviceType2 != AspectAdviceType.BEFORE) continue;
                    this.executeAdvice(adviceRule2, true);
                }
            } else {
                for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                    if (aspectAdviceRule.getAspectAdviceType() != AspectAdviceType.BEFORE) continue;
                    this.executeAdvice(aspectAdviceRule, true);
                }
            }
        }
    }

    @Override
    public void registerSettingsAdviceRule(SettingsAdviceRule settingsAdviceRule) {
        if (this.relevantAspectRules != null && this.relevantAspectRules.contains(settingsAdviceRule.getAspectRule())) {
            return;
        }
        this.touchRelevantAspectRules().add(settingsAdviceRule.getAspectRule());
        this.touchAspectAdviceRuleRegistry().addAspectAdviceRule(settingsAdviceRule);
    }

    @Override
    public void executeAdvice(List<AspectAdviceRule> aspectAdviceRuleList, boolean throwable) throws AspectAdviceException {
        if (aspectAdviceRuleList != null && !aspectAdviceRuleList.isEmpty()) {
            while (true) {
                AspectAdviceRule target = null;
                if (this.executedAdviceRules == null) {
                    target = aspectAdviceRuleList.get(0);
                } else {
                    for (AspectAdviceRule aspectAdviceRule : aspectAdviceRuleList) {
                        if (this.executedAdviceRules.contains(aspectAdviceRule)) continue;
                        target = aspectAdviceRule;
                        break;
                    }
                }
                if (target == null) break;
                this.executeAdvice(target, throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeAdvice(@NonNull AspectAdviceRule aspectAdviceRule, boolean throwable) throws AspectAdviceException {
        if (aspectAdviceRule.getAspectRule().isDisabled() || !this.isAcceptable(aspectAdviceRule.getAspectRule())) {
            this.touchExecutedAspectAdviceRules().add(aspectAdviceRule);
            return;
        }
        if (this.isExceptionRaised() && aspectAdviceRule.getExceptionRule() != null) {
            try {
                this.handleException(aspectAdviceRule.getExceptionRule());
            }
            catch (Exception e) {
                if (aspectAdviceRule.getAspectRule().isIsolated()) {
                    logger.error("Failed to execute isolated advice action " + String.valueOf(aspectAdviceRule), e);
                }
                if (throwable) {
                    throw new AspectAdviceException("Failed to execute advice action " + String.valueOf(aspectAdviceRule), aspectAdviceRule, e);
                }
                logger.error("Failed to execute advice action " + String.valueOf(aspectAdviceRule), e);
            }
        }
        this.touchExecutedAspectAdviceRules().add(aspectAdviceRule);
        Executable action = aspectAdviceRule.getAdviceAction();
        if (action != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Advice " + AspectAdviceRule.toString(action, aspectAdviceRule));
            }
            AspectAdviceRule oldAdviceRule = this.currentAdviceRule;
            this.currentAdviceRule = aspectAdviceRule;
            try {
                Object adviceBean = this.getAspectAdviceBean(aspectAdviceRule.getAspectId());
                if (adviceBean == null) {
                    if (aspectAdviceRule.getAdviceBeanClass() != null) {
                        adviceBean = this.getBean(aspectAdviceRule.getAdviceBeanClass());
                    } else if (aspectAdviceRule.getAdviceBeanId() != null) {
                        adviceBean = this.getBean(aspectAdviceRule.getAdviceBeanId());
                    }
                    this.putAspectAdviceBean(aspectAdviceRule.getAspectId(), adviceBean);
                }
                Object resultValue = action.execute(this);
                if (!action.isHidden() && resultValue != null && resultValue != Void.TYPE) {
                    this.putAspectAdviceResult(aspectAdviceRule, resultValue);
                    if (action.getActionType() == ActionType.ECHO) {
                        if (action.getActionId() != null) {
                            this.getRequestAdapter().setAttribute(action.getActionId(), resultValue);
                        } else {
                            Map echos = (Map)resultValue;
                            for (Map.Entry item : echos.entrySet()) {
                                this.getRequestAdapter().setAttribute((String)item.getKey(), item.getValue());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (aspectAdviceRule.getAspectRule().isIsolated()) {
                    logger.error("Failed to execute isolated advice action " + String.valueOf(aspectAdviceRule), e);
                } else {
                    this.setRaisedException(e);
                    if (throwable) {
                        throw new AspectAdviceException("Failed to execute advice action " + String.valueOf(aspectAdviceRule), aspectAdviceRule, e);
                    }
                    logger.error("Failed to execute advice action " + String.valueOf(aspectAdviceRule), e);
                }
            }
            finally {
                this.currentAdviceRule = oldAdviceRule;
            }
        }
    }

    private boolean isAcceptable(@NonNull AspectRule aspectRule) {
        if (aspectRule.getMethods() != null) {
            if (!this.hasTranslet()) {
                return false;
            }
            MethodType requestMethod = this.getTranslet().getRequestMethod();
            if (requestMethod == null || !requestMethod.containsTo(aspectRule.getMethods())) {
                return false;
            }
        }
        if (aspectRule.getHeaders() != null) {
            for (String header : aspectRule.getHeaders()) {
                if (!this.getRequestAdapter().containsHeader(header)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public void handleException(List<ExceptionRule> exceptionRuleList) throws ActionExecutionException {
        if (exceptionRuleList != null) {
            for (ExceptionRule exceptionRule : exceptionRuleList) {
                this.handleException(exceptionRule);
            }
        }
    }

    protected ExceptionThrownRule handleException(ExceptionRule exceptionRule) throws ActionExecutionException {
        ExceptionThrownRule exceptionThrownRule;
        if (exceptionRule != null && (exceptionThrownRule = exceptionRule.getExceptionThrownRule(this.getRaisedException())) != null) {
            Executable action = exceptionThrownRule.getAction();
            if (action != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Advice " + String.valueOf(action));
                }
                try {
                    Object resultValue = action.execute(this);
                    if (this.hasTranslet() && !action.isHidden() && resultValue != Void.TYPE) {
                        if (resultValue instanceof ProcessResult) {
                            ProcessResult processResult = (ProcessResult)resultValue;
                            this.getTranslet().setProcessResult(processResult);
                        } else {
                            ContentResult contentResult;
                            ProcessResult processResult = this.getTranslet().getProcessResult();
                            if (processResult == null) {
                                processResult = new ProcessResult(1);
                                contentResult = new ContentResult(processResult, 1);
                                this.getTranslet().setProcessResult(processResult);
                            } else {
                                contentResult = processResult.lastContentResult();
                                if (contentResult == null) {
                                    contentResult = new ContentResult(processResult, 1);
                                }
                            }
                            contentResult.addActionResult(action, resultValue);
                        }
                    }
                }
                catch (Exception e) {
                    this.setRaisedException(e);
                    throw new ActionExecutionException("Failed to execute exception handling advice action " + String.valueOf(action), (Throwable)e);
                }
            }
            return exceptionThrownRule;
        }
        return null;
    }

    protected List<AspectAdviceRule> getBeforeAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getBeforeAdviceRuleList();
        }
        return null;
    }

    protected List<AspectAdviceRule> getAfterAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getAfterAdviceRuleList();
        }
        return null;
    }

    protected List<AspectAdviceRule> getFinallyAdviceRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getFinallyAdviceRuleList();
        }
        return null;
    }

    protected List<ExceptionRule> getExceptionRuleList() {
        if (this.aspectAdviceRuleRegistry != null) {
            return this.aspectAdviceRuleRegistry.getExceptionRuleList();
        }
        return null;
    }

    @Override
    public <V> V getAspectAdviceBean(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAspectAdviceBean(aspectId) : null);
    }

    protected void putAspectAdviceBean(String aspectId, Object adviceBean) {
        if (this.aspectAdviceResult == null) {
            this.aspectAdviceResult = new AspectAdviceResult();
        }
        this.aspectAdviceResult.putAspectAdviceBean(aspectId, adviceBean);
    }

    @Override
    public <V> V getBeforeAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getBeforeAdviceResult(aspectId) : null);
    }

    @Override
    public <V> V getAfterAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAfterAdviceResult(aspectId) : null);
    }

    @Override
    public <V> V getAroundAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getAroundAdviceResult(aspectId) : null);
    }

    @Override
    public <V> V getFinallyAdviceResult(String aspectId) {
        return (V)(this.aspectAdviceResult != null ? this.aspectAdviceResult.getFinallyAdviceResult(aspectId) : null);
    }

    protected void putAspectAdviceResult(AspectAdviceRule aspectAdviceRule, Object adviceActionResult) {
        if (this.aspectAdviceResult == null) {
            this.aspectAdviceResult = new AspectAdviceResult();
        }
        this.aspectAdviceResult.putAspectAdviceResult(aspectAdviceRule, adviceActionResult);
    }

    private AspectAdviceRuleRegistry touchAspectAdviceRuleRegistry() {
        if (this.aspectAdviceRuleRegistry == null) {
            this.aspectAdviceRuleRegistry = new AspectAdviceRuleRegistry();
        }
        return this.aspectAdviceRuleRegistry;
    }

    private Set<AspectRule> touchRelevantAspectRules() {
        if (this.relevantAspectRules == null) {
            this.relevantAspectRules = new HashSet<AspectRule>();
        }
        return this.relevantAspectRules;
    }

    private Set<AspectAdviceRule> touchExecutedAspectAdviceRules() {
        if (this.executedAdviceRules == null) {
            this.executedAdviceRules = new HashSet<AspectAdviceRule>();
        }
        return this.executedAdviceRules;
    }
}

