/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.ActivityData;
import com.aspectran.core.activity.ActivityPerformException;
import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.AdviceActivity;
import com.aspectran.core.activity.CoreTranslet;
import com.aspectran.core.activity.InstantAction;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.activity.process.ContentList;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.request.MissingMandatoryAttributesException;
import com.aspectran.core.activity.request.MissingMandatoryParametersException;
import com.aspectran.core.activity.request.PathVariableMap;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.activity.response.ForwardResponse;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.ExceptionThrownRule;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleList;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.RequestRule;
import com.aspectran.core.context.rule.ResponseRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.core.context.rule.type.AspectAdviceType;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.core.support.i18n.locale.LocaleChangeInterceptor;
import com.aspectran.core.support.i18n.locale.LocaleResolver;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.ArrayList;

public class CoreActivity
extends AdviceActivity {
    private static final Logger logger = LoggerFactory.getLogger(CoreActivity.class);
    private final String contextPath;
    private CoreTranslet translet;
    private ActivityData activityData;
    private Response reservedResponse;
    private Response desiredResponse;
    private boolean adapted;
    private boolean requestParsed;
    private boolean forwarding;
    private boolean committed;

    protected CoreActivity(ActivityContext context) {
        this(context, null);
    }

    protected CoreActivity(ActivityContext context, String contextPath) {
        super(context);
        this.contextPath = StringUtils.emptyToNull(contextPath);
    }

    @Override
    public String getContextPath() {
        return this.contextPath;
    }

    @Override
    public String getReverseContextPath() {
        return this.contextPath;
    }

    public void prepare(String requestName) throws TransletNotFoundException, ActivityPrepareException {
        TransletRule transletRule = this.findTransletRule(requestName, MethodType.GET);
        if (transletRule == null) {
            throw new TransletNotFoundException(requestName, MethodType.GET);
        }
        this.prepare(requestName, MethodType.GET, transletRule);
    }

    public void prepare(TransletRule transletRule) throws ActivityPrepareException {
        this.prepare(transletRule.getName(), transletRule);
    }

    public void prepare(String requestName, TransletRule transletRule) throws ActivityPrepareException {
        this.prepare(requestName, MethodType.GET, transletRule);
    }

    public void prepare(String requestName, String requestMethod) throws TransletNotFoundException, ActivityPrepareException {
        this.prepare(requestName, MethodType.resolve(requestMethod));
    }

    public void prepare(String requestName, MethodType requestMethod) throws TransletNotFoundException, ActivityPrepareException {
        TransletRule transletRule;
        if (requestMethod == null) {
            requestMethod = MethodType.GET;
        }
        if ((transletRule = this.findTransletRule(requestName, requestMethod)) == null) {
            throw new TransletNotFoundException(requestName, requestMethod);
        }
        this.prepare(requestName, requestMethod, transletRule);
    }

    protected void prepare(String requestName, MethodType requestMethod, TransletRule transletRule) throws ActivityPrepareException {
        Assert.notNull((Object)requestName, "requestName must not be null");
        Assert.notNull((Object)requestMethod, "requestMethod must not be null");
        Assert.notNull((Object)transletRule, "transletRule must not be null");
        CoreTranslet prevTranslet = this.translet;
        try {
            MethodType allowedMethod;
            if (logger.isDebugEnabled()) {
                logger.debug("Translet " + String.valueOf(transletRule));
            }
            this.translet = new CoreTranslet(transletRule, this);
            this.translet.setRequestName(requestName);
            this.translet.setRequestMethod(requestMethod);
            if (prevTranslet != null) {
                this.translet.setProcessResult(prevTranslet.getProcessResult());
            }
            if ((allowedMethod = this.getRequestRule().getAllowedMethod()) != null && !allowedMethod.equals((Object)requestMethod)) {
                throw new RequestMethodNotAllowedException(allowedMethod);
            }
            this.prepareAspectAdviceRules(transletRule, transletRule.getName());
        }
        catch (Exception e) {
            throw new ActivityPrepareException("Failed to prepare activity for translet " + String.valueOf(transletRule), e);
        }
    }

    protected void adapt() throws AdapterException {
        this.adapted = true;
    }

    protected void parseRequest() throws RequestParseException, ActivityTerminatedException {
        this.parseDeclaredParameters();
        this.parseDeclaredAttributes();
        this.parsePathVariables();
        if (!this.forwarding) {
            this.resolveLocale();
        }
        this.requestParsed = true;
    }

    protected LocaleResolver resolveLocale() {
        String localeChangeInterceptorId;
        LocaleResolver localeResolver = null;
        String localeResolverBeanId = (String)this.getSetting("localeResolver");
        if (localeResolverBeanId != null) {
            localeResolver = this.getBean(LocaleResolver.class, localeResolverBeanId);
            localeResolver.resolveLocale(this.getTranslet());
            localeResolver.resolveTimeZone(this.getTranslet());
        }
        if (localeResolver != null && (localeChangeInterceptorId = (String)this.getSetting("localeChangeInterceptor")) != null) {
            LocaleChangeInterceptor localeChangeInterceptor = this.getBean(LocaleChangeInterceptor.class, localeChangeInterceptorId);
            localeChangeInterceptor.handle(this.getTranslet(), localeResolver);
        }
        return localeResolver;
    }

    @Override
    public void perform() throws ActivityPerformException {
        this.perform(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V perform(InstantAction<V> instantAction) throws ActivityPerformException {
        if (this.translet == null && instantAction == null) {
            throw new IllegalArgumentException("Either translet or instantAction is required");
        }
        V result = null;
        try {
            if (!this.adapted) {
                this.adapt();
            }
            if (!this.forwarding) {
                this.saveCurrentActivity();
            }
            if (this.translet != null && !this.requestParsed) {
                this.parseRequest();
            }
            try {
                this.setCurrentAdviceType(AspectAdviceType.BEFORE);
                this.executeAdvice(this.getBeforeAdviceRuleList(), true);
                if (this.translet != null) {
                    ForwardRule forwardRule;
                    if (!this.isResponseReserved()) {
                        this.produce();
                    }
                    if ((forwardRule = this.response()) != null) {
                        if (this.forwarding) {
                            this.forward(forwardRule);
                        } else {
                            this.forwarding = true;
                            this.forward(forwardRule);
                            this.forwarding = false;
                        }
                    }
                }
                if (!this.forwarding) {
                    if (instantAction != null) {
                        result = instantAction.execute();
                    }
                    this.setCurrentAdviceType(AspectAdviceType.AFTER);
                    this.executeAdvice(this.getAfterAdviceRuleList(), true);
                }
            }
            catch (Exception e) {
                this.setRaisedException(e);
            }
            finally {
                if (!this.forwarding) {
                    this.setCurrentAdviceType(AspectAdviceType.FINALLY);
                    this.executeAdvice(this.getFinallyAdviceRuleList(), false);
                }
            }
            if (!this.forwarding) {
                if (this.isExceptionRaised()) {
                    this.setCurrentAdviceType(AspectAdviceType.THROWN);
                    this.exception();
                    if (this.translet != null) {
                        this.response();
                    }
                    if (this.isExceptionRaised()) {
                        throw this.getRaisedException();
                    }
                }
                this.setCurrentAdviceType(null);
            }
        }
        catch (ActivityTerminatedException e) {
            throw e;
        }
        catch (Throwable e) {
            if (this.translet != null) {
                throw new ActivityPerformException("Failed to perform activity for Translet " + String.valueOf(this.translet.getTransletRule()), e);
            }
            if (instantAction != null) {
                throw new ActivityPerformException("Failed to perform activity for instant action " + String.valueOf(instantAction), e);
            }
            throw new ActivityPerformException("Failed to perform activity", e);
        }
        finally {
            if (!this.forwarding) {
                this.finish();
            }
        }
        return result;
    }

    private void produce() throws ActionExecutionException {
        ActionList actionList;
        ContentList contentList = this.getTransletRule().getContentList();
        if (contentList != null) {
            ProcessResult processResult = this.getTranslet().getProcessResult();
            if (processResult == null) {
                processResult = new ProcessResult(contentList.size());
                processResult.setName(contentList.getName());
                processResult.setExplicit(contentList.isExplicit());
                this.getTranslet().setProcessResult(processResult);
            }
            for (ActionList actionList2 : contentList) {
                this.execute(actionList2);
                if (!this.isResponseReserved()) continue;
                break;
            }
        }
        if ((actionList = this.getResponseRule().getActionList()) != null) {
            this.execute(actionList);
        }
    }

    @Nullable
    private ForwardRule response() throws ResponseException {
        if (this.committed) {
            return null;
        }
        this.committed = true;
        Response resp = this.getResponse();
        if (resp != null) {
            resp.commit(this);
            if (this.isExceptionRaised()) {
                this.clearRaisedException();
            }
            if (resp.getResponseType() == ResponseType.FORWARD) {
                ForwardResponse forwardResponse = (ForwardResponse)resp;
                return forwardResponse.getForwardRule();
            }
        }
        return null;
    }

    private void forward(@NonNull ForwardRule forwardRule) throws TransletNotFoundException, ActivityPrepareException, ActivityPerformException {
        this.reserveResponse(null);
        this.committed = false;
        this.requestParsed = false;
        this.prepare(forwardRule.getTransletName(), forwardRule.getRequestMethod());
        this.perform();
    }

    private void exception() throws ActionExecutionException {
        this.reserveResponse(null);
        this.committed = false;
        if (this.hasTranslet() && this.getTransletRule().getExceptionRule() != null) {
            this.handleException(this.getTransletRule().getExceptionRule());
        }
        if (this.getExceptionRuleList() != null) {
            this.handleException(this.getExceptionRuleList());
        }
    }

    private void finish() {
        try {
            if (this.getRequestAdapter() != null && this.getRequestAdapter().hasRequestScope()) {
                this.getRequestAdapter().getRequestScope().destroy();
            }
            if (this.getResponseAdapter() != null) {
                this.getResponseAdapter().flush();
            }
        }
        catch (Exception e) {
            logger.error("Error detected while finishing activity", e);
        }
        finally {
            this.removeCurrentActivity();
        }
    }

    protected void execute(ActionList actionList) throws ActionExecutionException {
        this.execute(actionList, null);
    }

    protected void execute(ActionList actionList, ContentResult contentResult) throws ActionExecutionException {
        if (contentResult == null) {
            ProcessResult processResult = this.getTranslet().getProcessResult();
            if (processResult == null) {
                processResult = new ProcessResult(2);
                this.getTranslet().setProcessResult(processResult);
            }
            if ((contentResult = processResult.getContentResult(actionList.getName(), actionList.isExplicit())) == null) {
                contentResult = new ContentResult(processResult, actionList.size());
                contentResult.setName(actionList.getName());
                if (!processResult.isExplicit()) {
                    contentResult.setExplicit(actionList.isExplicit());
                }
            }
        }
        for (Executable action : actionList) {
            this.execute(action, contentResult);
            if (!this.isResponseReserved()) continue;
            break;
        }
    }

    private void execute(Executable action, ContentResult contentResult) throws ActionExecutionException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Action " + String.valueOf(action));
            }
            if (action.getActionType() == ActionType.CHOOSE) {
                Object resultValue = action.execute(this);
                if (resultValue != Void.TYPE) {
                    ChooseWhenRule chooseWhenRule = (ChooseWhenRule)resultValue;
                    ActionList actionList = chooseWhenRule.getActionList();
                    this.execute(actionList, contentResult);
                    if (chooseWhenRule.getResponse() != null) {
                        this.reserveResponse(chooseWhenRule.getResponse());
                    }
                }
            } else {
                Object resultValue = action.execute(this);
                if (!action.isHidden() && contentResult != null && resultValue != Void.TYPE) {
                    if (resultValue instanceof ProcessResult) {
                        ProcessResult processResult = (ProcessResult)resultValue;
                        contentResult.addActionResult(action, processResult);
                    } else {
                        contentResult.addActionResult(action, resultValue);
                    }
                }
            }
        }
        catch (ActionExecutionException e) {
            this.setRaisedException(e);
            throw e;
        }
        catch (Exception e) {
            this.setRaisedException(e);
            throw new ActionExecutionException(action, (Throwable)e);
        }
    }

    @Override
    protected ExceptionThrownRule handleException(ExceptionRule exceptionRule) throws ActionExecutionException {
        Response response;
        String contentType;
        Response targetResponse;
        ExceptionThrownRule exceptionThrownRule = super.handleException(exceptionRule);
        if (this.hasTranslet() && exceptionThrownRule != null && !this.isResponseReserved() && (targetResponse = exceptionThrownRule.getResponse(contentType = (response = this.getDesiredResponse()) != null ? response.getContentType() : null)) != null) {
            this.reserveResponse(targetResponse);
        }
        return exceptionThrownRule;
    }

    private Response getResponse() {
        Response resp = this.reservedResponse;
        if (resp == null && !this.isExceptionRaised()) {
            resp = this.getDeclaredResponse();
        }
        return resp;
    }

    @Override
    public Response getDeclaredResponse() {
        return this.getResponseRule() != null ? this.getResponseRule().getResponse() : null;
    }

    protected void reserveResponse(@Nullable Response response) {
        this.reservedResponse = response;
        if (response != null && !this.isExceptionRaised()) {
            this.desiredResponse = response;
        }
    }

    protected void reserveResponse() {
        if (this.reservedResponse == null) {
            this.reservedResponse = this.getDeclaredResponse();
        }
    }

    @Override
    public boolean isResponseReserved() {
        return this.reservedResponse != null;
    }

    protected Response getDesiredResponse() {
        return this.desiredResponse != null ? this.desiredResponse : this.getDeclaredResponse();
    }

    @Override
    public boolean isCommitted() {
        return this.committed;
    }

    @Override
    public CoreTranslet getTranslet() {
        if (this.translet == null) {
            throw new IllegalStateException("No Translet");
        }
        return this.translet;
    }

    @Override
    public boolean hasTranslet() {
        return this.translet != null;
    }

    @Override
    public ProcessResult getProcessResult() {
        return this.translet != null ? this.translet.getProcessResult() : null;
    }

    @Override
    public Object getProcessResult(String actionId) {
        if (this.getProcessResult() != null) {
            return this.getProcessResult().getResultValue(actionId);
        }
        return null;
    }

    @Override
    public ActivityData getActivityData() {
        if (this.activityData == null) {
            this.activityData = new ActivityData(this);
        } else {
            this.activityData.refresh();
        }
        return this.activityData;
    }

    private TransletRule findTransletRule(String requestName, MethodType requestMethod) {
        return this.getActivityContext().getTransletRuleRegistry().getTransletRule(requestName, requestMethod);
    }

    protected TransletRule getTransletRule() {
        return this.getTranslet().getTransletRule();
    }

    protected RequestRule getRequestRule() {
        return this.getTranslet().getRequestRule();
    }

    protected ResponseRule getResponseRule() {
        return this.getTranslet().getResponseRule();
    }

    protected String getDefinitiveRequestEncoding() {
        String encoding = this.getRequestRule().getEncoding();
        if (encoding == null) {
            encoding = (String)this.getSetting("characterEncoding");
        }
        return encoding;
    }

    protected String getDefinitiveResponseEncoding() {
        String encoding = this.getResponseRule().getEncoding();
        if (encoding == null) {
            encoding = this.getDefinitiveRequestEncoding();
        }
        return encoding;
    }

    protected void parseDeclaredParameters() throws MissingMandatoryParametersException {
        ItemRuleMap itemRuleMap = this.getRequestRule().getParameterItemRuleMap();
        if (itemRuleMap != null && !itemRuleMap.isEmpty()) {
            ArrayList missingItemRules = null;
            for (ItemRule itemRule : itemRuleMap.values()) {
                String[] values;
                String[] newValues;
                String[] oldValues;
                if (itemRule.isEvaluable() && (oldValues = this.getRequestAdapter().getParameterValues(itemRule.getName())) != (newValues = this.getItemEvaluator().evaluateAsStringArray(itemRule))) {
                    this.getRequestAdapter().setParameter(itemRule.getName(), newValues);
                }
                if (!itemRule.isMandatory() || (values = this.getRequestAdapter().getParameterValues(itemRule.getName())) != null) continue;
                if (missingItemRules == null) {
                    missingItemRules = new ItemRuleList();
                }
                missingItemRules.add(itemRule);
            }
            if (missingItemRules != null) {
                throw new MissingMandatoryParametersException(missingItemRules);
            }
        }
    }

    protected void parseDeclaredAttributes() throws MissingMandatoryAttributesException {
        ItemRuleMap itemRuleMap = this.getRequestRule().getAttributeItemRuleMap();
        if (itemRuleMap != null && !itemRuleMap.isEmpty()) {
            ArrayList missingItemRules = null;
            for (ItemRule itemRule : itemRuleMap.values()) {
                Object value;
                Object newValue;
                Object oldValue;
                if (itemRule.isEvaluable() && (oldValue = this.getRequestAdapter().getAttribute(itemRule.getName())) != (newValue = this.getItemEvaluator().evaluate(itemRule))) {
                    this.getRequestAdapter().setAttribute(itemRule.getName(), newValue);
                }
                if (!itemRule.isMandatory() || (value = this.getRequestAdapter().getAttribute(itemRule.getName())) != null) continue;
                if (missingItemRules == null) {
                    missingItemRules = new ItemRuleList();
                }
                missingItemRules.add(itemRule);
            }
            if (missingItemRules != null) {
                throw new MissingMandatoryAttributesException(missingItemRules);
            }
        }
    }

    private void parsePathVariables() {
        PathVariableMap pathVariables;
        Token[] nameTokens = this.getTransletRule().getNameTokens();
        if (nameTokens != null && (nameTokens.length != 1 || nameTokens[0].getType() != TokenType.TEXT) && (pathVariables = PathVariableMap.parse(nameTokens, this.getTranslet().getRequestName())) != null) {
            pathVariables.applyTo(this.getTranslet());
        }
    }
}

