/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.adapter.DefaultRequestAdapter;
import com.aspectran.core.adapter.DefaultResponseAdapter;
import com.aspectran.core.adapter.DefaultSessionAdapter;
import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.adapter.SessionAdapter;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.utils.OutputStringWriter;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Map;

public class InstantActivity
extends CoreActivity {
    private final Activity.Mode mode;
    private Map<String, Object> attributeMap;
    private ParameterMap parameterMap;

    public InstantActivity(ActivityContext context) {
        super(context);
        this.mode = Activity.Mode.DEFAULT;
    }

    public InstantActivity(@NonNull Activity activity) {
        this(activity, true);
    }

    public InstantActivity(@NonNull Activity activity, boolean inheritResponseAdapter) {
        super(activity.getActivityContext());
        this.mode = activity.getMode();
        this.setSessionAdapter(activity.getSessionAdapter());
        this.setRequestAdapter(activity.getRequestAdapter());
        if (inheritResponseAdapter) {
            this.setResponseAdapter(activity.getResponseAdapter());
        }
    }

    @Override
    public Activity.Mode getMode() {
        return this.mode;
    }

    @Override
    public void setSessionAdapter(SessionAdapter sessionAdapter) {
        super.setSessionAdapter(sessionAdapter);
    }

    @Override
    public void setRequestAdapter(RequestAdapter requestAdapter) {
        super.setRequestAdapter(requestAdapter);
    }

    @Override
    public void setResponseAdapter(ResponseAdapter responseAdapter) {
        super.setResponseAdapter(responseAdapter);
    }

    public void setAttributeMap(Map<String, Object> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public void setParameterMap(ParameterMap parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Override
    protected void adapt() throws AdapterException {
        if (this.getSessionAdapter() == null && this.getParentActivity() != null) {
            this.setSessionAdapter(this.getParentActivity().getSessionAdapter());
        }
        if (this.getRequestAdapter() == null) {
            MethodType requestMethod = this.hasTranslet() ? this.getTranslet().getRequestMethod() : null;
            DefaultRequestAdapter requestAdapter = new DefaultRequestAdapter(requestMethod);
            this.setRequestAdapter(requestAdapter);
        }
        if (this.attributeMap != null) {
            this.getRequestAdapter().putAllAttributes(this.attributeMap);
        }
        if (this.parameterMap != null) {
            this.getRequestAdapter().putAllParameters(this.parameterMap);
        }
        if (this.getResponseAdapter() == null) {
            OutputStringWriter writer = new OutputStringWriter();
            DefaultResponseAdapter responseAdapter = new DefaultResponseAdapter(null, writer);
            this.setResponseAdapter(responseAdapter);
        }
        super.adapt();
    }

    @Override
    protected void saveCurrentActivity() {
        SessionAdapter sessionAdapter;
        super.saveCurrentActivity();
        if (!this.hasParentActivity() && (sessionAdapter = this.getSessionAdapter()) instanceof DefaultSessionAdapter) {
            DefaultSessionAdapter sessionAdapter2 = (DefaultSessionAdapter)sessionAdapter;
            sessionAdapter2.getSessionAgent().access();
        }
    }

    @Override
    protected void removeCurrentActivity() {
        SessionAdapter sessionAdapter;
        if (!this.hasParentActivity() && (sessionAdapter = this.getSessionAdapter()) instanceof DefaultSessionAdapter) {
            DefaultSessionAdapter sessionAdapter2 = (DefaultSessionAdapter)sessionAdapter;
            sessionAdapter2.getSessionAgent().complete();
        }
        super.removeCurrentActivity();
    }
}

