/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantAction;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.InstantActivityException;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.component.template.TemplateRenderer;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.env.Environment;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.support.i18n.message.MessageSource;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;

@AvoidAdvice
public abstract class InstantActivitySupport
implements ActivityContextAware {
    private ActivityContext context;

    @NonNull
    protected ActivityContext getActivityContext() {
        Assert.state(this.context != null, "No ActivityContext injected");
        return this.context;
    }

    @Override
    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        Assert.state(this.context == null, "ActivityContext already injected");
        this.context = context;
    }

    protected Activity getAvailableActivity() {
        return this.getActivityContext().getAvailableActivity();
    }

    protected Activity getCurrentActivity() {
        return this.getActivityContext().getCurrentActivity();
    }

    protected boolean hasCurrentActivity() {
        return this.getActivityContext().hasCurrentActivity();
    }

    protected ApplicationAdapter getApplicationAdapter() {
        return this.getActivityContext().getApplicationAdapter();
    }

    protected Environment getEnvironment() {
        return this.getActivityContext().getEnvironment();
    }

    protected BeanRegistry getBeanRegistry() {
        return this.getActivityContext().getBeanRegistry();
    }

    protected TemplateRenderer getTemplateRenderer() {
        return this.getActivityContext().getTemplateRenderer();
    }

    protected MessageSource getMessageSource() {
        return this.getActivityContext().getMessageSource();
    }

    protected <V> V instantActivity(InstantAction<V> instantAction) {
        if (instantAction == null) {
            throw new IllegalArgumentException("instantAction must not be null");
        }
        try {
            InstantActivity activity = new InstantActivity(this.getActivityContext());
            return activity.perform(instantAction);
        }
        catch (Exception e) {
            throw new InstantActivityException(e);
        }
    }

    protected void instantActivity(String requestName) {
        this.instantActivity(requestName, MethodType.GET);
    }

    protected void instantActivity(String requestName, MethodType requestMethod) {
        if (StringUtils.isEmpty(requestName)) {
            throw new IllegalArgumentException("requestName must not be null or empty");
        }
        Activity currentActivity = this.getCurrentActivity();
        Translet translet = currentActivity.getTranslet();
        if (translet == null) {
            throw new IllegalStateException("No Translet in " + String.valueOf(currentActivity));
        }
        try {
            InstantActivity activity = new InstantActivity(currentActivity);
            activity.prepare(requestName, requestMethod);
            activity.perform();
        }
        catch (Exception e) {
            throw new InstantActivityException(e);
        }
    }
}

