/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity;

import com.aspectran.core.activity.ActivityException;
import com.aspectran.core.context.rule.type.MethodType;

public class TransletNotFoundException
extends ActivityException {
    private static final long serialVersionUID = -5619283297296999361L;
    private final String transletName;
    private final MethodType requestMethod;

    public TransletNotFoundException(String requestName) {
        this(requestName, (MethodType)null);
    }

    public TransletNotFoundException(String requestName, MethodType requestMethod) {
        super("No such translet mapped to " + TransletNotFoundException.makeRequestName(requestName, requestMethod));
        this.transletName = requestName;
        this.requestMethod = requestMethod;
    }

    public String getTransletName() {
        if (this.requestMethod == null || this.requestMethod == MethodType.GET) {
            return this.transletName;
        }
        return String.valueOf((Object)this.requestMethod) + " " + this.transletName;
    }

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    public MethodType getRequestMethod(MethodType defaultRequestMethod) {
        return this.requestMethod != null ? this.requestMethod : defaultRequestMethod;
    }

    private static String makeRequestName(String requestName, MethodType requestMethod) {
        if (requestMethod != null) {
            return String.valueOf((Object)requestMethod) + " " + requestName;
        }
        return requestName;
    }
}

