/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process;

import com.aspectran.core.activity.process.ActionList;
import com.aspectran.core.context.rule.ability.Replicable;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.ArrayList;
import java.util.Objects;

public class ContentList
extends ArrayList<ActionList>
implements Replicable<ContentList> {
    private static final long serialVersionUID = 2567969961069441527L;
    private final boolean explicit;
    @Nullable
    private String name;

    public ContentList(boolean explicit) {
        super(3);
        this.explicit = explicit;
    }

    private ContentList(ContentList contentList) {
        super(contentList);
        this.explicit = contentList.isExplicit();
        this.name = contentList.getName();
    }

    public boolean isExplicit() {
        return this.explicit;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public ActionList getActionList(String name) {
        for (ActionList actionList : this) {
            if (!Objects.equals(name, actionList.getName())) continue;
            return actionList;
        }
        return null;
    }

    public void addActionList(ActionList actionList) {
        if (actionList != null) {
            this.add(actionList);
        }
    }

    @Override
    public ContentList replicate() {
        return new ContentList(this);
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("name", this.name);
        tsb.append("contents", this);
        return tsb.toString();
    }

    @NonNull
    public static ContentList newInstance(String name) {
        ContentList contentList = new ContentList(true);
        contentList.setName(name);
        return contentList;
    }
}

