/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.InvokeAction;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class AdviceAction
extends InvokeAction {
    private final AspectAdviceRule aspectAdviceRule;

    public AdviceAction(AspectAdviceRule aspectAdviceRule, InvokeActionRule invokeActionRule) {
        super(invokeActionRule);
        this.aspectAdviceRule = aspectAdviceRule;
    }

    public AspectAdviceRule getAspectAdviceRule() {
        return this.aspectAdviceRule;
    }

    @Override
    protected Object resolveBean(@NonNull Activity activity) throws Exception {
        if (this.getInvokeActionRule().getBeanId() != null || this.getInvokeActionRule().getBeanClass() != null) {
            return super.resolveBean(activity);
        }
        Object bean = activity.getAspectAdviceBean(this.aspectAdviceRule.getAspectId());
        if (bean == null) {
            throw new ActionExecutionException("No advice bean found for " + String.valueOf(this.aspectAdviceRule));
        }
        return bean;
    }

    @Override
    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("type", (Object)this.aspectAdviceRule.getAspectAdviceType());
        if (this.getInvokeActionRule().getBeanId() != null || this.getInvokeActionRule().getBeanClass() != null) {
            tsb.append("action", super.toString());
        } else if (this.getInvokeActionRule().getMethod() != null) {
            tsb.append("method", this.getInvokeActionRule().getMethod());
        } else {
            tsb.append("bean", this.aspectAdviceRule.getAdviceBeanId());
            if (this.aspectAdviceRule.getAdviceBeanId() == null) {
                tsb.append("bean", this.aspectAdviceRule.getAdviceBeanClass());
            }
            tsb.append("method", this.getInvokeActionRule().getMethodName());
        }
        if (this.aspectAdviceRule.getAspectRule().getOrder() != Integer.MAX_VALUE) {
            tsb.append("order", this.aspectAdviceRule.getAspectRule().getOrder());
        }
        return tsb.toString();
    }
}

