/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.action.MethodArgumentTypeMismatchException;
import com.aspectran.core.activity.process.action.ParameterBindingException;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.annotation.Component;
import com.aspectran.core.component.bean.annotation.Format;
import com.aspectran.core.component.bean.annotation.Qualifier;
import com.aspectran.core.component.bean.annotation.Required;
import com.aspectran.core.context.rule.AnnotatedActionRule;
import com.aspectran.core.context.rule.ParameterBindingRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.utils.BeanDescriptor;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AnnotatedAction
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedAction.class);
    private static final Object NONE = new Object();
    private final AnnotatedActionRule annotatedActionRule;

    public AnnotatedAction(AnnotatedActionRule annotatedActionRule) {
        this.annotatedActionRule = annotatedActionRule;
    }

    @Override
    public Object execute(@NonNull Activity activity) throws Exception {
        try {
            Object bean = this.resolveBean(activity);
            Method method = this.annotatedActionRule.getMethod();
            ParameterBindingRule[] parameterBindingRules = this.annotatedActionRule.getParameterBindingRules();
            if (method.getReturnType() == Void.TYPE) {
                AnnotatedAction.invokeMethod(activity, bean, method, parameterBindingRules);
                return Void.TYPE;
            }
            return AnnotatedAction.invokeMethod(activity, bean, method, parameterBindingRules);
        }
        catch (Exception e) {
            throw new ActionExecutionException(this, (Throwable)e);
        }
    }

    protected Object resolveBean(@NonNull Activity activity) throws Exception {
        Object bean = null;
        if (!Modifier.isInterface(this.annotatedActionRule.getBeanClass().getModifiers())) {
            bean = activity.getBean(this.annotatedActionRule.getBeanClass());
        }
        return bean;
    }

    public AnnotatedActionRule getAnnotatedActionRule() {
        return this.annotatedActionRule;
    }

    @Override
    public String getActionId() {
        return this.annotatedActionRule.getActionId();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.INVOKE_ANNOTATED;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append(this.getActionType().toString(), this.annotatedActionRule);
        return tsb.toString();
    }

    public static Object invokeMethod(@NonNull Activity activity, @Nullable Object bean, @NonNull Method method, @Nullable ParameterBindingRule[] parameterBindingRules) throws Exception {
        ParameterBindingRule parameterBindingRule = null;
        try {
            if (parameterBindingRules == null) {
                return method.invoke(bean, MethodUtils.EMPTY_OBJECT_ARRAY);
            }
            Translet translet = activity.getTranslet();
            Object[] args = new Object[parameterBindingRules.length];
            for (int i = 0; i < parameterBindingRules.length; ++i) {
                parameterBindingRule = parameterBindingRules[i];
                Class<?> type = parameterBindingRule.getType();
                String name = parameterBindingRule.getName();
                String format = parameterBindingRule.getFormat();
                boolean required = parameterBindingRule.isRequired();
                Exception thrown = null;
                try {
                    if (translet != null) {
                        StringifyContext stringifyContext = activity.getStringifyContext();
                        args[i] = AnnotatedAction.resolveArgumentWithTranslet(translet, type, name, stringifyContext, format);
                    } else {
                        args[i] = AnnotatedAction.resolveArgument(activity, type, name);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw e;
                }
                catch (MethodArgumentTypeMismatchException e) {
                    thrown = e;
                    if (e.getCause() instanceof NumberFormatException && type.isPrimitive()) {
                        args[i] = 0;
                    }
                }
                catch (Exception e) {
                    thrown = e;
                }
                if (required && (args[i] == null || thrown != null)) {
                    if (thrown != null) {
                        throw new IllegalArgumentException("Missing required parameter '" + name + "'; Cause: " + thrown.getMessage(), thrown);
                    }
                    throw new IllegalArgumentException("Missing required parameter '" + name + "'");
                }
                if (thrown == null || !logger.isDebugEnabled()) continue;
                logger.debug("Failed to bind argument " + String.valueOf(parameterBindingRule) + "; Cause: " + thrown.getMessage(), thrown);
            }
            parameterBindingRule = null;
            return method.invoke(bean, args);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            throw e;
        }
        catch (Exception e) {
            if (parameterBindingRule != null) {
                throw new ParameterBindingException(parameterBindingRule, (Throwable)e);
            }
            throw e;
        }
    }

    private static Object resolveArgumentWithTranslet(Translet translet, Class<?> type, String name, StringifyContext stringifyContext, String format) throws MethodArgumentTypeMismatchException, RequestParseException {
        Object result;
        if (type == Translet.class) {
            result = translet;
        } else if (type.isArray()) {
            if ((type = type.getComponentType()) == Translet.class) {
                result = new Translet[]{translet};
            } else {
                String[] values = translet.getParameterValues(name);
                result = AnnotatedAction.resolveValue(type, values, stringifyContext, format);
                if (result == NONE) {
                    result = null;
                }
            }
        } else if (type == ParameterMap.class) {
            ParameterMap parameterMap = new ParameterMap();
            for (String paramName : translet.getParameterNames()) {
                parameterMap.setParameterValues(paramName, translet.getParameterValues(paramName));
            }
            result = parameterMap;
        } else if (Map.class.isAssignableFrom(type)) {
            if (!type.isInterface()) {
                Map map = (Map)ClassUtils.createInstance(type);
                map.putAll(translet.getAllParameters());
                result = map;
            } else {
                result = new HashMap<String, Object>(translet.getAllParameters());
            }
        } else if (Collection.class.isAssignableFrom(type)) {
            String[] values = translet.getParameterValues(name);
            if (!type.isInterface()) {
                Collection collection = (Collection)ClassUtils.createInstance(type);
                if (values != null) {
                    collection.addAll(Arrays.asList(values));
                }
                result = collection;
            } else {
                result = values != null ? new ArrayList<String>(Arrays.asList(values)) : new ArrayList();
            }
        } else {
            if (Parameters.class.isAssignableFrom(type)) {
                Parameters parameters;
                if (type.isInterface()) {
                    parameters = translet.getRequestAdapter().getBodyAsParameters();
                    if (parameters == null) {
                        parameters = translet.getRequestAdapter().getParameters();
                    }
                } else {
                    Class<?> requiredType = type;
                    parameters = translet.getRequestAdapter().getBodyAsParameters(requiredType);
                    if (parameters == null) {
                        parameters = translet.getRequestAdapter().getParameters(requiredType);
                    }
                }
                return parameters;
            }
            String value = translet.getParameter(name);
            result = AnnotatedAction.resolveValue(type, value, stringifyContext, format);
            if (result == NONE) {
                if (type.isAnnotationPresent(Component.class)) {
                    try {
                        result = translet.getBean(type);
                    }
                    catch (NoUniqueBeanException e) {
                        result = translet.getBean(type, name);
                    }
                } else {
                    result = AnnotatedAction.parseModel((Translet)translet, type, stringifyContext);
                }
            }
        }
        return result;
    }

    private static Object resolveArgument(Activity activity, Class<?> type, String name) throws MethodArgumentTypeMismatchException {
        Object result;
        if (type == Translet.class) {
            result = null;
        } else if (type.isArray() && type.getComponentType() == Translet.class) {
            result = new Translet[]{};
        } else {
            try {
                result = activity.getBean(type);
            }
            catch (NoUniqueBeanException e) {
                result = activity.getBean(type, name);
            }
        }
        return result;
    }

    @NonNull
    private static Object parseModel(Translet translet, Class<?> type, StringifyContext stringifyContext) {
        Object model = ClassUtils.createInstance(type);
        BeanDescriptor bd = BeanDescriptor.getInstance(type);
        ArrayList<String> missingProperties = new ArrayList<String>();
        for (String name : bd.getWritablePropertyNames()) {
            try {
                Object result;
                String format;
                Method method = bd.getSetter(name);
                Class<?> setterType = bd.getSetterType(name);
                Qualifier qualifierAnno = bd.getSetterAnnotation(method, Qualifier.class);
                String paramName = qualifierAnno != null ? qualifierAnno.value() : name;
                Format formatAnno = bd.getSetterAnnotation(method, Format.class);
                String string = format = formatAnno != null ? formatAnno.value() : null;
                if (setterType.isArray()) {
                    setterType = setterType.getComponentType();
                    String[] values = translet.getParameterValues(paramName);
                    result = AnnotatedAction.resolveValue(setterType, values, stringifyContext, format);
                } else {
                    String value = translet.getParameter(paramName);
                    result = AnnotatedAction.resolveValue(setterType, value, stringifyContext, format);
                }
                if (result != null && result != NONE) {
                    BeanUtils.setProperty(model, name, result);
                    continue;
                }
                if (!method.isAnnotationPresent(Required.class)) continue;
                missingProperties.add(name);
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug(e);
            }
        }
        if (!missingProperties.isEmpty()) {
            String properties = StringUtils.joinCommaDelimitedList(missingProperties);
            throw new IllegalArgumentException("Missing required properties [" + properties + "] for " + String.valueOf(type));
        }
        return model;
    }

    private static Object resolveValue(Class<?> type, String value, StringifyContext stringifyContext, String format) throws MethodArgumentTypeMismatchException {
        try {
            Object result = null;
            if (type == String.class) {
                result = value;
            } else if (type == Character.TYPE) {
                result = value != null && !value.isEmpty() ? Character.valueOf(value.charAt(0)) : Character.valueOf('\u0000');
            } else if (type == Character.class) {
                if (value != null && !value.isEmpty()) {
                    result = Character.valueOf(value.charAt(0));
                }
            } else if (type == Boolean.TYPE) {
                result = Boolean.valueOf(value);
            } else if (type == Boolean.class) {
                if (value != null) {
                    result = Boolean.valueOf(value);
                }
            } else if (type == Byte.TYPE) {
                result = value != null ? (Number)Byte.valueOf(value) : (Number)0;
            } else if (type == Byte.class) {
                if (value != null) {
                    result = Byte.valueOf(value);
                }
            } else if (type == Short.TYPE) {
                result = value != null ? (Number)Short.valueOf(value) : (Number)0;
            } else if (type == Short.class) {
                if (value != null) {
                    result = Short.valueOf(value);
                }
            } else if (type == Integer.TYPE) {
                result = value != null ? Integer.valueOf(value) : Integer.valueOf(0);
            } else if (type == Integer.class) {
                if (value != null) {
                    result = Integer.valueOf(value);
                }
            } else if (type == Long.TYPE) {
                result = value != null ? Long.valueOf(value) : Long.valueOf(0L);
            } else if (type == Long.class) {
                if (value != null) {
                    result = Long.valueOf(value);
                }
            } else if (type == Float.TYPE) {
                result = value != null ? Float.valueOf(value) : Float.valueOf(0.0f);
            } else if (type == Float.class) {
                if (value != null) {
                    result = Float.valueOf(value);
                }
            } else if (type == Double.TYPE) {
                result = value != null ? Double.valueOf(value) : Double.valueOf(0.0);
            } else if (type == Double.class) {
                if (value != null) {
                    result = Double.valueOf(value);
                }
            } else if (type == BigInteger.class) {
                if (value != null) {
                    result = new BigInteger(value);
                }
            } else if (type == BigDecimal.class) {
                if (value != null) {
                    result = new BigDecimal(value);
                }
            } else if (type == LocalDateTime.class) {
                if (value != null) {
                    result = stringifyContext.toLocalDateTime(value, format);
                }
            } else if (type == LocalDate.class) {
                if (value != null) {
                    result = stringifyContext.toLocalDate(value, format);
                }
            } else if (type == LocalTime.class) {
                if (value != null) {
                    result = stringifyContext.toLocalTime(value, format);
                }
            } else if (type == Date.class) {
                if (value != null) {
                    result = stringifyContext.toDate(value, format);
                }
            } else {
                result = NONE;
            }
            return result;
        }
        catch (Exception e) {
            throw new MethodArgumentTypeMismatchException(String.class, type, e);
        }
    }

    private static Object resolveValue(Class<?> type, String[] values, StringifyContext stringifyContext, String format) throws MethodArgumentTypeMismatchException {
        try {
            Object result = null;
            if (type == String.class) {
                result = values;
            } else if (type == Character.TYPE) {
                if (values != null) {
                    char[] arr = new char[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = !values[i].isEmpty() ? values[i].charAt(0) : (char)'\u0000';
                    }
                    result = arr;
                } else {
                    result = new char[0];
                }
            } else if (type == Character.class) {
                if (values != null) {
                    Character[] arr = new Character[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = !values[i].isEmpty() ? Character.valueOf(values[i].charAt(0)) : null;
                    }
                    result = arr;
                }
            } else if (type == Boolean.TYPE) {
                if (values != null) {
                    boolean[] arr = new boolean[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Boolean.parseBoolean(values[i]);
                    }
                    result = arr;
                } else {
                    result = new boolean[0];
                }
            } else if (type == Boolean.class) {
                if (values != null) {
                    Boolean[] arr = new Boolean[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Boolean.valueOf(values[i]);
                    }
                    result = arr;
                }
            } else if (type == Byte.TYPE) {
                if (values != null) {
                    byte[] arr = new byte[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Byte.parseByte(values[i]);
                    }
                    result = arr;
                } else {
                    result = new byte[0];
                }
            } else if (type == Byte.class) {
                if (values != null) {
                    Byte[] arr = new Byte[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Byte.valueOf(values[i]);
                    }
                    result = arr;
                }
            } else if (type == Short.TYPE) {
                if (values != null) {
                    short[] arr = new short[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Short.parseShort(values[i]);
                    }
                    result = arr;
                } else {
                    result = new short[0];
                }
            } else if (type == Short.class) {
                if (values != null) {
                    Short[] arr = new Short[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Short.valueOf(values[i]);
                    }
                    result = arr;
                }
            } else if (type == Integer.TYPE) {
                if (values != null) {
                    int[] arr = new int[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Integer.parseInt(values[i]);
                    }
                    result = arr;
                } else {
                    result = new int[0];
                }
            } else if (type == Integer.class) {
                if (values != null) {
                    Integer[] arr = new Integer[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Integer.valueOf(values[i]);
                    }
                    result = arr;
                }
            } else if (type == Long.TYPE) {
                if (values != null) {
                    long[] arr = new long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Long.parseLong(values[i]);
                    }
                    result = arr;
                } else {
                    result = new long[0];
                }
            } else if (type == Long.class) {
                if (values != null) {
                    Long[] arr = new Long[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Long.valueOf(values[i]);
                    }
                    result = arr;
                }
            } else if (type == Float.TYPE) {
                if (values != null) {
                    float[] arr = new float[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Float.parseFloat(values[i]);
                    }
                    result = arr;
                } else {
                    result = new float[0];
                }
            } else if (type == Float.class) {
                if (values != null) {
                    Float[] arr = new Float[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Float.valueOf(values[i]);
                    }
                    result = arr;
                }
            } else if (type == Double.TYPE) {
                if (values != null) {
                    double[] arr = new double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Double.parseDouble(values[i]);
                    }
                    result = arr;
                } else {
                    result = new double[0];
                }
            } else if (type == Double.class) {
                if (values != null) {
                    Double[] arr = new Double[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = Double.valueOf(values[i]);
                    }
                    result = arr;
                }
            } else if (type == BigInteger.class) {
                if (values != null) {
                    BigInteger[] arr = new BigInteger[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = new BigInteger(values[i]);
                    }
                    result = arr;
                }
            } else if (type == BigDecimal.class) {
                if (values != null) {
                    BigDecimal[] arr = new BigDecimal[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = new BigDecimal(values[i]);
                    }
                    result = arr;
                }
            } else if (type == LocalDateTime.class) {
                if (values != null) {
                    LocalDateTime[] arr = new LocalDateTime[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = stringifyContext.toLocalDateTime(values[i], format);
                    }
                    result = arr;
                }
            } else if (type == LocalDate.class) {
                if (values != null) {
                    LocalDate[] arr = new LocalDate[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = stringifyContext.toLocalDate(values[i], format);
                    }
                    result = arr;
                }
            } else if (type == LocalTime.class) {
                if (values != null) {
                    LocalTime[] arr = new LocalTime[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = stringifyContext.toLocalTime(values[i], format);
                    }
                    result = arr;
                }
            } else if (type == Date.class) {
                if (values != null) {
                    Date[] arr = new Date[values.length];
                    for (int i = 0; i < values.length; ++i) {
                        arr[i] = stringifyContext.toDate(values[i], format);
                    }
                    result = arr;
                }
            } else {
                result = NONE;
            }
            return result;
        }
        catch (Exception e) {
            throw new MethodArgumentTypeMismatchException(String[].class, type, e);
        }
    }
}

