/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.context.asel.value.BooleanExpression;
import com.aspectran.core.context.rule.ChooseRule;
import com.aspectran.core.context.rule.ChooseWhenRule;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.List;

public class ChooseAction
implements Executable {
    private final ChooseRule chooseRule;
    private final List<ChooseWhenRule> chooseWhenRules;

    public ChooseAction(@NonNull ChooseRule chooseRule) {
        this.chooseRule = chooseRule;
        this.chooseWhenRules = chooseRule.getChooseWhenRules();
    }

    @Override
    public Object execute(@NonNull Activity activity) throws Exception {
        if (this.chooseWhenRules != null) {
            for (ChooseWhenRule chooseWhenRule : this.chooseWhenRules) {
                BooleanExpression booleanEvaluation = chooseWhenRule.getBooleanExpression();
                if (booleanEvaluation != null && !booleanEvaluation.evaluate(activity)) continue;
                return chooseWhenRule;
            }
        }
        return Void.TYPE;
    }

    public ChooseRule getChooseRule() {
        return this.chooseRule;
    }

    @Override
    public ActionType getActionType() {
        return ActionType.CHOOSE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append(this.getActionType().toString(), this.chooseRule);
        return tsb.toString();
    }
}

