/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.context.rule.EchoActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class EchoAction
implements Executable {
    private final EchoActionRule echoActionRule;

    public EchoAction(EchoActionRule echoActionRule) {
        this.echoActionRule = echoActionRule;
    }

    @Override
    public Object execute(@NonNull Activity activity) throws Exception {
        ItemRuleMap itemRuleMap = this.echoActionRule.getEchoItemRuleMap();
        if (itemRuleMap == null || itemRuleMap.isEmpty()) {
            return Void.TYPE;
        }
        try {
            return activity.getItemEvaluator().evaluate(itemRuleMap);
        }
        catch (Exception e) {
            throw new ActionExecutionException(this, (Throwable)e);
        }
    }

    public EchoActionRule getEchoActionRule() {
        return this.echoActionRule;
    }

    @Override
    public String getActionId() {
        return this.echoActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.echoActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ECHO;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append(this.getActionType().toString(), this.echoActionRule);
        return tsb.toString();
    }
}

