/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.asel.item.ItemEvaluator;
import com.aspectran.core.context.rule.HeaderActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.List;
import java.util.Map;

public class HeaderAction
implements Executable {
    private final HeaderActionRule headerActionRule;

    public HeaderAction(HeaderActionRule headerActionRule) {
        this.headerActionRule = headerActionRule;
    }

    @Override
    public Object execute(@NonNull Activity activity) throws Exception {
        ItemRuleMap itemRuleMap = this.headerActionRule.getHeaderItemRuleMap();
        if (itemRuleMap == null || itemRuleMap.isEmpty()) {
            return Void.TYPE;
        }
        try {
            ItemEvaluator itemEvaluator = activity.getItemEvaluator();
            MultiValueMap<String, String> valueMap = itemEvaluator.evaluateAsMultiValueMap(itemRuleMap);
            if (!valueMap.isEmpty()) {
                ResponseAdapter responseAdapter = activity.getResponseAdapter();
                for (Map.Entry entry : valueMap.entrySet()) {
                    String name = (String)entry.getKey();
                    List values = (List)entry.getValue();
                    for (String value : values) {
                        responseAdapter.addHeader(name, value);
                    }
                }
            }
            return valueMap;
        }
        catch (Exception e) {
            throw new ActionExecutionException(this, (Throwable)e);
        }
    }

    public HeaderActionRule getHeaderActionRule() {
        return this.headerActionRule;
    }

    @Override
    public String getActionId() {
        return this.headerActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.headerActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.HEADER;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append(this.getActionType().toString(), this.headerActionRule);
        return tsb.toString();
    }
}

