/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.context.rule.IncludeActionRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Map;

public class IncludeAction
implements Executable {
    private final IncludeActionRule includeActionRule;

    public IncludeAction(IncludeActionRule includeActionRule) {
        this.includeActionRule = includeActionRule;
    }

    @Override
    public Object execute(@NonNull Activity activity) throws Exception {
        try {
            InstantActivity instantActivity = new InstantActivity(activity);
            ItemRuleMap attributeItemRuleMap = this.includeActionRule.getAttributeItemRuleMap();
            ItemRuleMap parameterItemRuleMap = this.includeActionRule.getParameterItemRuleMap();
            if (attributeItemRuleMap != null && !attributeItemRuleMap.isEmpty()) {
                Map<String, Object> attributeMap = activity.getItemEvaluator().evaluate(attributeItemRuleMap);
                instantActivity.setAttributeMap(attributeMap);
            }
            if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
                ParameterMap parameterMap = activity.getItemEvaluator().evaluateAsParameterMap(parameterItemRuleMap);
                instantActivity.setParameterMap(parameterMap);
            }
            instantActivity.prepare(this.includeActionRule.getTransletName(), this.includeActionRule.getMethodType());
            instantActivity.perform();
            ProcessResult processResult = instantActivity.getProcessResult();
            return processResult != null ? processResult : Void.TYPE;
        }
        catch (Exception e) {
            throw new ActionExecutionException(this, (Throwable)e);
        }
    }

    public IncludeActionRule getIncludeActionRule() {
        return this.includeActionRule;
    }

    @Override
    public String getActionId() {
        return this.includeActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.includeActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.INCLUDE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append(this.getActionType().toString(), this.includeActionRule);
        return tsb.toString();
    }
}

