/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.process.action;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.Translet;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.activity.process.action.Executable;
import com.aspectran.core.context.rule.InvokeActionRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ItemRuleUtils;
import com.aspectran.core.context.rule.type.ActionType;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class InvokeAction
implements Executable {
    private static final Logger logger = LoggerFactory.getLogger(InvokeAction.class);
    private final InvokeActionRule invokeActionRule;
    private volatile Boolean requiresTranslet;

    public InvokeAction(InvokeActionRule invokeActionRule) {
        this.invokeActionRule = invokeActionRule;
    }

    @Override
    public Object execute(@NonNull Activity activity) throws Exception {
        Object bean = this.resolveBean(activity);
        return this.execute(activity, bean);
    }

    protected Object resolveBean(@NonNull Activity activity) throws Exception {
        Object bean = null;
        if (this.invokeActionRule.getBeanClass() != null) {
            bean = activity.getBean(this.invokeActionRule.getBeanClass());
        } else if (this.invokeActionRule.getBeanId() != null) {
            bean = activity.getBean(this.invokeActionRule.getBeanId());
        }
        if (bean == null) {
            throw new ActionExecutionException("No bean found for " + String.valueOf(this.invokeActionRule));
        }
        return bean;
    }

    private Object execute(Activity activity, Object bean) throws Exception {
        try {
            Object result;
            Method method;
            ItemRuleMap propertyItemRuleMap = this.invokeActionRule.getPropertyItemRuleMap();
            ItemRuleMap argumentItemRuleMap = this.invokeActionRule.getArgumentItemRuleMap();
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                Map<String, Object> valueMap = activity.getItemEvaluator().evaluate(propertyItemRuleMap);
                for (Map.Entry<String, Object> entry : valueMap.entrySet()) {
                    BeanUtils.setProperty(bean, entry.getKey(), entry.getValue());
                }
            }
            if ((method = this.invokeActionRule.getMethod()) != null) {
                if (argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
                    Object[] args = InvokeAction.createArguments(activity, argumentItemRuleMap, this.invokeActionRule.isRequiresTranslet());
                    return InvokeAction.invokeMethod(bean, method, args);
                }
                return InvokeAction.invokeMethod(activity, bean, method, this.invokeActionRule.isRequiresTranslet());
            }
            String methodName = this.invokeActionRule.getMethodName();
            if (activity.hasTranslet()) {
                if (this.requiresTranslet == null) {
                    try {
                        result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, true);
                        this.requiresTranslet = Boolean.TRUE;
                    }
                    catch (NoSuchMethodException e) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("No such accessible method to invoke action " + String.valueOf(this.invokeActionRule));
                        }
                        this.requiresTranslet = Boolean.FALSE;
                        result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, false);
                    }
                } else {
                    result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, this.requiresTranslet);
                }
            } else {
                result = InvokeAction.invokeMethod(activity, bean, methodName, argumentItemRuleMap, false);
            }
            return result;
        }
        catch (ActionExecutionException e) {
            throw e;
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof Exception) {
                throw new ActionExecutionException(this, e.getCause());
            }
            throw new ActionExecutionException(this, (Throwable)e);
        }
        catch (Exception e) {
            throw new ActionExecutionException(this, (Throwable)e);
        }
    }

    public InvokeActionRule getInvokeActionRule() {
        return this.invokeActionRule;
    }

    @Override
    public String getActionId() {
        return this.invokeActionRule.getActionId();
    }

    @Override
    public boolean isHidden() {
        return this.invokeActionRule.isHidden();
    }

    @Override
    public ActionType getActionType() {
        return ActionType.INVOKE;
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append(this.getActionType().toString(), this.invokeActionRule);
        return tsb.toString();
    }

    private static Object invokeMethod(Activity activity, Object bean, Method method, boolean requiresTranslet) throws Exception {
        Object[] args = requiresTranslet ? new Object[]{activity.getTranslet()} : MethodUtils.EMPTY_OBJECT_ARRAY;
        return InvokeAction.invokeMethod(bean, method, args);
    }

    private static Object invokeMethod(Object bean, @NonNull Method method, Object[] args) throws Exception {
        if (method.getReturnType() == Void.TYPE) {
            method.invoke(bean, args);
            return Void.TYPE;
        }
        return method.invoke(bean, args);
    }

    private static Object invokeMethod(Activity activity, Object bean, String methodName, ItemRuleMap argumentItemRuleMap, boolean requiresTranslet) throws Exception {
        Class[] argsTypes = null;
        Object[] argsObjects = null;
        if (argumentItemRuleMap != null && !argumentItemRuleMap.isEmpty()) {
            int argIndex;
            Map<String, Object> valueMap = activity.getItemEvaluator().evaluate(argumentItemRuleMap);
            int argSize = argumentItemRuleMap.size();
            if (requiresTranslet) {
                argIndex = 1;
                argsTypes = new Class[argSize + argIndex];
                argsObjects = new Object[argsTypes.length];
                argsTypes[0] = Translet.class;
                argsObjects[0] = activity.getTranslet();
            } else {
                argIndex = 0;
                argsTypes = new Class[argSize];
                argsObjects = new Object[argsTypes.length];
            }
            for (ItemRule ir : argumentItemRuleMap.values()) {
                Object o = valueMap.get(ir.getName());
                argsTypes[argIndex] = ItemRuleUtils.getPrototypeClass(ir, o);
                argsObjects[argIndex] = o;
                ++argIndex;
            }
        } else if (requiresTranslet) {
            argsTypes = new Class[]{Translet.class};
            argsObjects = new Object[]{activity.getTranslet()};
        }
        return InvokeAction.invokeMethod(bean, methodName, argsObjects, argsTypes);
    }

    private static Object invokeMethod(@NonNull Object object, String methodName, Object[] args, Class<?>[] paramTypes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = MethodUtils.getMatchingAccessibleMethod(object.getClass(), methodName, args, paramTypes);
        if (method == null) {
            throw new NoSuchMethodException("No such accessible method: " + methodName + "() on object: " + object.getClass().getName());
        }
        if (method.getReturnType() == Void.TYPE) {
            MethodUtils.invokeMethod(object, method, args, paramTypes);
            return Void.TYPE;
        }
        return MethodUtils.invokeMethod(object, method, args, paramTypes);
    }

    @NonNull
    private static Object[] createArguments(@NonNull Activity activity, @NonNull ItemRuleMap argumentItemRuleMap, boolean requiresTranslet) {
        Object[] args;
        int index;
        int size = argumentItemRuleMap.size();
        if (requiresTranslet) {
            index = 1;
            args = new Object[size + index];
            args[0] = activity.getTranslet();
        } else {
            index = 0;
            args = new Object[size];
        }
        Map<String, Object> valueMap = activity.getItemEvaluator().evaluate(argumentItemRuleMap);
        for (String name : argumentItemRuleMap.keySet()) {
            Object o;
            args[index] = o = valueMap.get(name);
            ++index;
        }
        return args;
    }
}

