/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.request;

import com.aspectran.core.activity.Translet;
import com.aspectran.core.context.asel.token.Token;
import com.aspectran.core.context.rule.type.TokenType;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.HashMap;
import java.util.Map;

public class PathVariableMap
extends HashMap<Token, String> {
    private static final long serialVersionUID = -3327966082696522044L;

    public void applyTo(Translet translet) {
        for (Map.Entry entry : this.entrySet()) {
            Token token = (Token)entry.getKey();
            if (token.getType() == TokenType.PARAMETER) {
                translet.setParameter(token.getName(), (String)entry.getValue());
                continue;
            }
            if (token.getType() != TokenType.ATTRIBUTE) continue;
            translet.setAttribute(token.getName(), entry.getValue());
        }
    }

    @Nullable
    public static PathVariableMap parse(Token[] nameTokens, String requestName) {
        Assert.notNull((Object)nameTokens, "nameTokens must not be null");
        Assert.notNull((Object)requestName, "requestName must not be null");
        PathVariableMap pathVariables = new PathVariableMap();
        int beginIndex = 0;
        Token prevToken = null;
        Token lastToken = null;
        for (Token token : nameTokens) {
            TokenType type = token.getType();
            if (type == TokenType.PARAMETER || type == TokenType.ATTRIBUTE) {
                lastToken = token;
            } else {
                String term = token.stringify();
                int endIndex = requestName.indexOf(term, beginIndex);
                if (endIndex == -1) {
                    return null;
                }
                if (endIndex > beginIndex) {
                    String value = requestName.substring(beginIndex, endIndex);
                    if (prevToken != null) {
                        if (!value.isEmpty()) {
                            pathVariables.put(prevToken, value);
                        }
                    } else if (!term.equals(value)) {
                        return null;
                    }
                    beginIndex += value.length();
                } else if (prevToken != null && prevToken.getDefaultValue() != null) {
                    pathVariables.put(prevToken, prevToken.getDefaultValue());
                }
                beginIndex += term.length();
            }
            prevToken = token.getType() != TokenType.TEXT ? token : null;
        }
        if (lastToken != null && prevToken == lastToken) {
            String value = requestName.substring(beginIndex);
            if (!value.isEmpty()) {
                pathVariables.put(lastToken, value);
            } else if (lastToken.getDefaultValue() != null) {
                pathVariables.put(lastToken, lastToken.getDefaultValue());
            }
        }
        return pathVariables;
    }
}

