/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.context.rule.ForwardRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Map;

public class ForwardResponse
implements Response {
    private static final Logger logger = LoggerFactory.getLogger(ForwardResponse.class);
    private final ForwardRule forwardRule;

    public ForwardResponse(ForwardRule forwardRule) {
        this.forwardRule = forwardRule;
    }

    @Override
    public void commit(Activity activity) {
        ItemRuleMap itemRuleMap;
        if (logger.isDebugEnabled()) {
            logger.debug("Response " + String.valueOf(this.forwardRule));
        }
        if ((itemRuleMap = this.forwardRule.getAttributeItemRuleMap()) != null && !itemRuleMap.isEmpty()) {
            Map<String, Object> valueMap = activity.getItemEvaluator().evaluate(itemRuleMap);
            activity.getRequestAdapter().putAllAttributes(valueMap);
        }
    }

    @Override
    public ResponseType getResponseType() {
        return ForwardRule.RESPONSE_TYPE;
    }

    @Override
    public String getContentType() {
        if (this.forwardRule != null) {
            return this.forwardRule.getContentType();
        }
        return null;
    }

    @Override
    public Response replicate() {
        return new ForwardResponse(this.forwardRule.replicate());
    }

    public ForwardRule getForwardRule() {
        return this.forwardRule;
    }

    public String toString() {
        return this.forwardRule.toString();
    }
}

