/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.RedirectRule;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public class RedirectResponse
implements Response {
    private static final Logger logger = LoggerFactory.getLogger(RedirectResponse.class);
    private final RedirectRule redirectRule;

    public RedirectResponse(RedirectRule redirectRule) {
        this.redirectRule = redirectRule;
    }

    @Override
    public void commit(Activity activity) throws ResponseException {
        RedirectRule newRedirectRule = this.redirectRule.replicate();
        if (logger.isDebugEnabled()) {
            logger.debug("Response " + String.valueOf(newRedirectRule));
        }
        try {
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            if (newRedirectRule.getEncoding() != null) {
                responseAdapter.setEncoding(newRedirectRule.getEncoding());
            } else {
                String encoding = activity.getTranslet().getDefinitiveResponseEncoding();
                if (encoding != null) {
                    responseAdapter.setEncoding(encoding);
                    newRedirectRule.setEncoding(encoding);
                } else {
                    newRedirectRule.setEncoding(responseAdapter.getEncoding());
                }
            }
            responseAdapter.redirect(newRedirectRule);
        }
        catch (Exception e) {
            throw new ResponseException("Failed to respond with redirect rule " + String.valueOf(newRedirectRule), e);
        }
    }

    @Override
    public ResponseType getResponseType() {
        return RedirectRule.RESPONSE_TYPE;
    }

    @Override
    public String getContentType() {
        if (this.redirectRule != null) {
            return this.redirectRule.getContentType();
        }
        return null;
    }

    @Override
    public Response replicate() {
        return new RedirectResponse(this.redirectRule.replicate());
    }

    public RedirectRule getRedirectRule() {
        return this.redirectRule;
    }

    public String toString() {
        return this.redirectRule.toString();
    }
}

