/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.apon.ContentsToParameters;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.AponWriter;
import com.aspectran.utils.apon.Parameters;
import java.io.IOException;
import java.io.Writer;

public class AponTransformResponse
extends TransformResponse {
    private final String contentType;
    private final String encoding;
    private final Boolean pretty;

    public AponTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.contentType = transformRule.getContentType();
        this.encoding = transformRule.getEncoding();
        this.pretty = transformRule.getPretty();
    }

    @Override
    public void transform(@NonNull Activity activity) throws Exception {
        ProcessResult processResult;
        String encoding;
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (this.encoding != null) {
            responseAdapter.setEncoding(this.encoding);
        } else if (responseAdapter.getEncoding() == null && (encoding = activity.getTranslet().getDefinitiveResponseEncoding()) != null) {
            responseAdapter.setEncoding(encoding);
        }
        if (this.contentType != null) {
            responseAdapter.setContentType(this.contentType);
        }
        if ((processResult = activity.getProcessResult()) != null && !processResult.isEmpty()) {
            Writer writer = responseAdapter.getWriter();
            StringifyContext stringifyContext = activity.getStringifyContext();
            Parameters parameters = ContentsToParameters.from(processResult, stringifyContext);
            AponTransformResponse.transform(parameters, writer, stringifyContext, this.pretty);
        }
    }

    @Override
    public Response replicate() {
        TransformRule transformRule = this.getTransformRule().replicate();
        return new AponTransformResponse(transformRule);
    }

    public static void transform(Parameters parameters, Writer writer, StringifyContext stringifyContext) throws IOException {
        AponTransformResponse.transform(parameters, writer, stringifyContext, null);
    }

    private static void transform(Parameters parameters, Writer writer, StringifyContext stringifyContext, Boolean prettyForce) throws IOException {
        AponWriter aponWriter = new AponWriter(writer);
        aponWriter.setStringifyContext(stringifyContext);
        if (prettyForce != null) {
            aponWriter.setPrettyPrint(prettyForce);
        }
        aponWriter.write(parameters);
    }
}

