/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.ResponseException;
import com.aspectran.core.activity.response.transform.CustomTransformResponseException;
import com.aspectran.core.activity.response.transform.CustomTransformer;
import com.aspectran.core.context.rule.CustomTransformRule;
import com.aspectran.core.context.rule.type.ResponseType;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.ListIterator;

public class CustomTransformResponse
implements Response {
    private static final Logger logger = LoggerFactory.getLogger(CustomTransformResponse.class);
    private static final ResponseType RESPONSE_TYPE = ResponseType.TRANSFORM;
    private final CustomTransformRule customTransformRule;

    public CustomTransformResponse() {
        this.customTransformRule = CustomTransformRule.DEFAULT;
    }

    public CustomTransformResponse(CustomTransformer transformer) {
        this.customTransformRule = CustomTransformRule.newInstance(transformer);
    }

    @Override
    public void commit(@NonNull Activity activity) throws ResponseException {
        CustomTransformer transformer = this.customTransformRule.getTransformer();
        if (transformer == null) {
            transformer = this.findTransformer(activity.getProcessResult());
        }
        if (transformer == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Response " + String.valueOf(transformer));
        }
        try {
            transformer.transform(activity);
        }
        catch (Exception e) {
            throw new CustomTransformResponseException(transformer, (Throwable)e);
        }
    }

    @Override
    public ResponseType getResponseType() {
        return RESPONSE_TYPE;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public Response replicate() {
        throw new UnsupportedOperationException("Non-Replicable");
    }

    public String toString() {
        return this.customTransformRule.toString();
    }

    private CustomTransformer findTransformer(ProcessResult processResult) {
        if (processResult != null) {
            ListIterator iter1 = processResult.listIterator(processResult.size());
            while (iter1.hasPrevious()) {
                ContentResult contentResult = (ContentResult)iter1.previous();
                ListIterator iter2 = contentResult.listIterator(contentResult.size());
                while (iter2.hasPrevious()) {
                    ActionResult actionResult = (ActionResult)iter2.previous();
                    if (actionResult == null || !(actionResult.getResultValue() instanceof CustomTransformer)) continue;
                    return (CustomTransformer)actionResult.getResultValue();
                }
            }
        }
        return null;
    }
}

