/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.Response;
import com.aspectran.core.activity.response.transform.TransformResponse;
import com.aspectran.core.activity.response.transform.xml.ContentsInputSource;
import com.aspectran.core.activity.response.transform.xml.ContentsXMLReader;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.TransformRule;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;

public class XmlTransformResponse
extends TransformResponse {
    private static final String OUTPUT_METHOD_XML = "xml";
    private static final String INDENT_NUMBER_KEY = "indent-number";
    private static final Integer DEFAULT_INDENT_SIZE = 2;
    private static final String YES = "yes";
    private final String contentType;
    private final String encoding;
    private final Boolean pretty;

    public XmlTransformResponse(TransformRule transformRule) {
        super(transformRule);
        this.contentType = transformRule.getContentType();
        this.encoding = transformRule.getEncoding();
        this.pretty = transformRule.getPretty();
    }

    @Override
    protected void transform(@NonNull Activity activity) throws Exception {
        String encoding;
        ResponseAdapter responseAdapter = activity.getResponseAdapter();
        if (this.encoding != null) {
            encoding = this.encoding;
        } else {
            encoding = responseAdapter.getEncoding();
            if (encoding == null) {
                encoding = activity.getTranslet().getDefinitiveResponseEncoding();
            }
        }
        if (encoding != null) {
            responseAdapter.setEncoding(encoding);
        }
        if (this.contentType != null) {
            responseAdapter.setContentType(this.contentType);
        }
        ProcessResult processResult = activity.getProcessResult();
        Writer writer = responseAdapter.getWriter();
        StringifyContext stringifyContext = activity.getStringifyContext();
        if (this.pretty != null && stringifyContext.isPretty() != this.pretty.booleanValue()) {
            stringifyContext = stringifyContext.clone();
            stringifyContext.setPretty(this.pretty);
        }
        XmlTransformResponse.transform(processResult, writer, encoding, stringifyContext, this.pretty);
    }

    @Override
    public Response replicate() {
        return new XmlTransformResponse(this.getTransformRule().replicate());
    }

    public static void transform(Object object, Writer writer, String encoding, StringifyContext stringifyContext) throws TransformerException {
        XmlTransformResponse.transform(object, writer, encoding, stringifyContext, null);
    }

    private static void transform(Object object, Writer writer, String encoding, StringifyContext stringifyContext, Boolean prettyForce) throws TransformerException {
        boolean pretty = prettyForce != null ? prettyForce : stringifyContext == null || stringifyContext.isPretty();
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        if (pretty) {
            if (stringifyContext != null && stringifyContext.hasIndentSize()) {
                transformerFactory.setAttribute(INDENT_NUMBER_KEY, stringifyContext.getIndentSize());
            } else {
                transformerFactory.setAttribute(INDENT_NUMBER_KEY, DEFAULT_INDENT_SIZE);
            }
        }
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", OUTPUT_METHOD_XML);
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        if (pretty) {
            transformer.setOutputProperty("indent", YES);
            transformer.setOutputProperty("doctype-public", YES);
        }
        ContentsXMLReader xmlReader = new ContentsXMLReader();
        xmlReader.setStringifyContext(stringifyContext);
        ContentsInputSource inputSource = new ContentsInputSource(object);
        SAXSource source = new SAXSource(xmlReader, inputSource);
        transformer.transform(source, new StreamResult(writer));
    }
}

