/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.activity.response.transform.xml;

import com.aspectran.core.activity.process.result.ActionResult;
import com.aspectran.core.activity.process.result.ContentResult;
import com.aspectran.core.activity.process.result.ProcessResult;
import com.aspectran.core.activity.response.transform.xml.ContentsInputSource;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class ContentsXMLReader
implements XMLReader {
    private static final String CONTENTS_TAG = "contents";
    private static final String CONTENT_TAG = "content";
    private static final String ROWS_TAG = "rows";
    private static final String ROW_TAG = "row";
    private static final Attributes NULL_ATTRS = new AttributesImpl();
    private StringifyContext stringifyContext;
    private ContentHandler handler;

    public void setStringifyContext(StringifyContext stringifyContext) {
        this.stringifyContext = stringifyContext;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.handler;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorhandler) {
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public void parse(String s) throws IOException, SAXException {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setEntityResolver(EntityResolver entityresolver) {
    }

    @Override
    public void setDTDHandler(DTDHandler dtdhandler) {
    }

    @Override
    public Object getProperty(String name) {
        return null;
    }

    @Override
    public void setProperty(String s, Object obj) {
    }

    @Override
    public void setFeature(String s, boolean flag) {
    }

    @Override
    public boolean getFeature(String name) {
        return false;
    }

    @Override
    public void parse(InputSource is) throws SAXException {
        if (this.handler == null) {
            throw new SAXException("No XML ContentHandler");
        }
        ContentsInputSource cis = (ContentsInputSource)is;
        Object data = cis.getData();
        this.handler.startDocument();
        if (data != null) {
            if (data instanceof ProcessResult) {
                ProcessResult processResult = (ProcessResult)data;
                if (!processResult.isEmpty()) {
                    this.parseProcessResult(processResult);
                }
            } else {
                this.parseObject(data);
            }
        }
        this.handler.endDocument();
    }

    private void parseProcessResult(@NonNull ProcessResult processResult) throws SAXException {
        String contentsName = processResult.getName();
        if (processResult.isExplicit()) {
            if (contentsName != null) {
                this.handler.startElement("", contentsName, contentsName, NULL_ATTRS);
            } else {
                this.handler.startElement("", CONTENTS_TAG, CONTENTS_TAG, NULL_ATTRS);
            }
        }
        for (ContentResult contentResult : processResult) {
            String contentName = contentResult.getName();
            if (contentResult.isExplicit()) {
                if (contentName != null) {
                    this.handler.startElement("", contentName, contentName, NULL_ATTRS);
                } else {
                    this.handler.startElement("", CONTENT_TAG, CONTENT_TAG, NULL_ATTRS);
                }
            }
            for (ActionResult actionResult : contentResult) {
                String actionId = actionResult.getActionId();
                Object resultValue = actionResult.getResultValue();
                if (actionId != null) {
                    this.handler.startElement("", actionId, actionId, NULL_ATTRS);
                }
                this.parseObject(resultValue);
                if (actionId == null) continue;
                this.handler.endElement("", actionId, actionId);
            }
            if (!contentResult.isExplicit()) continue;
            if (contentResult.getName() != null) {
                this.handler.endElement("", contentName, contentName);
                continue;
            }
            this.handler.endElement("", CONTENT_TAG, CONTENT_TAG);
        }
        if (processResult.isExplicit()) {
            if (contentsName != null) {
                this.handler.endElement("", contentsName, contentsName);
            } else {
                this.handler.endElement("", CONTENTS_TAG, CONTENTS_TAG);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseObject(Object object) throws SAXException {
        block19: {
            block30: {
                block29: {
                    block28: {
                        block27: {
                            block26: {
                                void var13_15;
                                block25: {
                                    block24: {
                                        block23: {
                                            block22: {
                                                block21: {
                                                    block20: {
                                                        block18: {
                                                            if (object == null) {
                                                                return;
                                                            }
                                                            if (!(object instanceof ProcessResult)) break block18;
                                                            ProcessResult processResult = (ProcessResult)object;
                                                            this.parseProcessResult(processResult);
                                                            break block19;
                                                        }
                                                        if (!(object instanceof String) && !(object instanceof Number) && !(object instanceof Boolean)) break block20;
                                                        this.parseString(object.toString());
                                                        break block19;
                                                    }
                                                    if (!(object instanceof Parameters)) break block21;
                                                    Parameters parameters = (Parameters)object;
                                                    for (Parameter parameter : parameters.getParameterValues()) {
                                                        String name = parameter.getName();
                                                        Object value = parameter.getValue();
                                                        this.checkCircularReference(object, value);
                                                        this.handler.startElement("", name, name, NULL_ATTRS);
                                                        this.parseObject(value);
                                                        this.handler.endElement("", name, name);
                                                    }
                                                    break block19;
                                                }
                                                if (!(object instanceof Map)) break block22;
                                                Map map = (Map)object;
                                                for (Map.Entry entry : map.entrySet()) {
                                                    String name = entry.getKey().toString();
                                                    Object value = entry.getValue();
                                                    this.checkCircularReference(object, value);
                                                    this.handler.startElement("", name, name, NULL_ATTRS);
                                                    this.parseObject(value);
                                                    this.handler.endElement("", name, name);
                                                }
                                                break block19;
                                            }
                                            if (!(object instanceof Collection)) break block23;
                                            Collection collection = (Collection)object;
                                            this.handler.startElement("", ROWS_TAG, ROWS_TAG, NULL_ATTRS);
                                            for (Object e : collection) {
                                                this.checkCircularReference(object, e);
                                                this.handler.startElement("", ROW_TAG, ROW_TAG, NULL_ATTRS);
                                                this.parseObject(e);
                                                this.handler.endElement("", ROW_TAG, ROW_TAG);
                                            }
                                            this.handler.endElement("", ROWS_TAG, ROWS_TAG);
                                            break block19;
                                        }
                                        if (!(object instanceof Iterator)) break block24;
                                        Iterator iterator = (Iterator)object;
                                        this.handler.startElement("", ROWS_TAG, ROWS_TAG, NULL_ATTRS);
                                        while (iterator.hasNext()) {
                                            Object value = iterator.next();
                                            this.checkCircularReference(object, value);
                                            this.handler.startElement("", ROW_TAG, ROW_TAG, NULL_ATTRS);
                                            this.parseObject(value);
                                            this.handler.endElement("", ROW_TAG, ROW_TAG);
                                        }
                                        this.handler.endElement("", ROWS_TAG, ROWS_TAG);
                                        break block19;
                                    }
                                    if (!(object instanceof Enumeration)) break block25;
                                    Enumeration enumeration = (Enumeration)object;
                                    this.handler.startElement("", ROWS_TAG, ROWS_TAG, NULL_ATTRS);
                                    while (enumeration.hasMoreElements()) {
                                        Object value = enumeration.nextElement();
                                        this.checkCircularReference(object, value);
                                        this.handler.startElement("", ROW_TAG, ROW_TAG, NULL_ATTRS);
                                        this.parseObject(value);
                                        this.handler.endElement("", ROW_TAG, ROW_TAG);
                                    }
                                    this.handler.endElement("", ROWS_TAG, ROWS_TAG);
                                    break block19;
                                }
                                if (!object.getClass().isArray()) break block26;
                                this.handler.startElement("", ROWS_TAG, ROWS_TAG, NULL_ATTRS);
                                int len = Array.getLength(object);
                                boolean bl = false;
                                while (var13_15 < len) {
                                    Object value = Array.get(object, (int)var13_15);
                                    this.checkCircularReference(object, value);
                                    this.handler.startElement("", ROW_TAG, ROW_TAG, NULL_ATTRS);
                                    this.parseObject(value);
                                    this.handler.endElement("", ROW_TAG, ROW_TAG);
                                    ++var13_15;
                                }
                                this.handler.endElement("", ROWS_TAG, ROWS_TAG);
                                break block19;
                            }
                            if (!(object instanceof LocalDateTime)) break block27;
                            LocalDateTime localDateTime = (LocalDateTime)object;
                            if (this.stringifyContext != null) {
                                this.parseString(this.stringifyContext.toString(localDateTime));
                            } else {
                                this.parseString(localDateTime.toString());
                            }
                            break block19;
                        }
                        if (!(object instanceof LocalDate)) break block28;
                        LocalDate localDate = (LocalDate)object;
                        if (this.stringifyContext != null) {
                            this.parseString(this.stringifyContext.toString(localDate));
                        } else {
                            this.parseString(localDate.toString());
                        }
                        break block19;
                    }
                    if (!(object instanceof LocalTime)) break block29;
                    LocalTime localTime = (LocalTime)object;
                    if (this.stringifyContext != null) {
                        this.parseString(this.stringifyContext.toString(localTime));
                    } else {
                        this.parseString(localTime.toString());
                    }
                    break block19;
                }
                if (!(object instanceof Date)) break block30;
                Date date = (Date)object;
                if (this.stringifyContext != null) {
                    this.parseString(this.stringifyContext.toString(date));
                } else {
                    this.parseString(date.toString());
                }
                break block19;
            }
            String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
            if (readablePropertyNames == null) break block19;
            for (String name : readablePropertyNames) {
                Object value;
                try {
                    value = BeanUtils.getProperty(object, name);
                }
                catch (InvocationTargetException e) {
                    throw new SAXException(e);
                }
                this.checkCircularReference(object, value);
                this.handler.startElement("", name, name, NULL_ATTRS);
                this.parseObject(value);
                this.handler.endElement("", name, name);
            }
        }
    }

    private void parseString(@NonNull String s) throws SAXException {
        this.handler.characters(s.toCharArray(), 0, s.length());
    }

    private void checkCircularReference(@NonNull Object wrapper, Object member) throws SAXException {
        if (wrapper.equals(member)) {
            throw new SAXException("XML Serialization Failure: A circular reference was detected while converting a member object [" + String.valueOf(member) + "] in [" + String.valueOf(wrapper) + "]");
        }
    }
}

