/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.adapter;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.utils.Assert;
import com.aspectran.utils.ResourceUtils;
import com.aspectran.utils.StringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URL;

public abstract class AbstractApplicationAdapter
implements ApplicationAdapter {
    private final String basePath;

    public AbstractApplicationAdapter(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String toRealPath(String filePath) throws IOException {
        return this.toRealPathAsFile(filePath).getCanonicalPath();
    }

    @Override
    public File toRealPathAsFile(String filePath) throws IOException {
        File file;
        Assert.notNull((Object)filePath, "filePath must not be null");
        if (filePath.startsWith("file:")) {
            URI uri = URI.create(filePath);
            file = new File(uri);
        } else if (filePath.startsWith("classpath:")) {
            String path = filePath.substring("classpath:".length());
            URL url = ResourceUtils.getResource(path);
            if (!"file".equals(url.getProtocol())) {
                throw new FileNotFoundException("Could not find resource file for given classpath: " + path);
            }
            file = new File(url.getFile());
        } else {
            file = StringUtils.hasText(this.basePath) ? new File(this.basePath, filePath) : new File(filePath);
        }
        return file;
    }
}

