/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component;

import com.aspectran.core.component.Component;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;

public abstract class AbstractComponent
implements Component {
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponent.class);
    private final AutoLock lock = new AutoLock();
    private volatile boolean initializing;
    private volatile boolean initialized;
    private volatile boolean destroying;
    private volatile boolean destroyed;

    protected abstract void doInitialize() throws Exception;

    protected abstract void doDestroy() throws Exception;

    @Override
    public void initialize() throws Exception {
        try (AutoLock ignored = this.lock.lock();){
            if (this.destroyed) {
                throw new IllegalStateException("Already destroyed " + this.getComponentName());
            }
            if (this.initialized) {
                throw new IllegalStateException("Already initialized " + this.getComponentName());
            }
            this.initializing = true;
            try {
                this.doInitialize();
            }
            finally {
                this.initializing = false;
            }
            this.initialized = true;
            if (logger.isDebugEnabled()) {
                logger.debug("Initialized " + this.getComponentName());
            }
        }
    }

    @Override
    public void destroy() {
        try (AutoLock ignored = this.lock.lock();){
            if (!this.initialized) {
                throw new IllegalStateException("Not yet initialized " + this.getComponentName());
            }
            if (this.destroying || this.destroyed) {
                throw new IllegalStateException("Already destroyed " + this.getComponentName());
            }
            this.destroying = true;
            try {
                this.doDestroy();
                if (logger.isDebugEnabled()) {
                    logger.debug("Destroyed " + this.getComponentName());
                }
            }
            catch (Exception e) {
                logger.warn("Failed to destroy " + this.getComponentName(), e);
            }
            finally {
                this.destroying = false;
            }
            this.destroyed = true;
        }
    }

    @Override
    public boolean isAvailable() {
        return this.initialized && !this.destroying && !this.destroyed;
    }

    @Override
    public boolean isInitializable() {
        return !this.initialized && !this.initializing && !this.destroying && !this.destroyed;
    }

    @Override
    public boolean isInitializing() {
        return this.initializing;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isDestroying() {
        return this.destroying;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public void checkInitializable() {
        if (this.isDestroyed() || this.isDestroying()) {
            throw new IllegalStateException("Already destroyed " + this.getComponentName());
        }
        if (this.isInitializing()) {
            throw new IllegalStateException("Already initializing " + this.getComponentName());
        }
        if (this.isInitialized()) {
            throw new IllegalStateException("Already initialized " + this.getComponentName());
        }
    }

    public void checkAvailable() {
        if (this.isDestroyed() || this.isDestroying()) {
            throw new IllegalStateException("Already destroyed " + this.getComponentName());
        }
        if (!this.isInitialized()) {
            throw new IllegalStateException("Not yet initialized");
        }
    }

    @Override
    public String getComponentName() {
        return ObjectUtils.simpleIdentityToString(this);
    }
}

