/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect;

import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.component.aspect.pointcut.PointcutPattern;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.translet.TransletRuleRegistry;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.JoinpointTargetType;
import com.aspectran.utils.BeanDescriptor;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.List;
import java.util.Set;

public class AspectAdviceRulePreRegister {
    private final AspectRuleRegistry aspectRuleRegistry;
    private boolean pointcutPatternVerifiable;

    public AspectAdviceRulePreRegister(@NonNull AspectRuleRegistry aspectRuleRegistry) {
        this.aspectRuleRegistry = aspectRuleRegistry;
        block0: for (AspectRule aspectRule : aspectRuleRegistry.getAspectRules()) {
            List<PointcutPatternRule> pointcutPatternRuleList;
            JoinpointTargetType joinpointTargetType = aspectRule.getJoinpointTargetType();
            if (joinpointTargetType == JoinpointTargetType.METHOD) {
                aspectRule.setBeanRelevant(true);
                continue;
            }
            Pointcut pointcut = aspectRule.getPointcut();
            if (pointcut == null || (pointcutPatternRuleList = pointcut.getPointcutPatternRuleList()) == null) continue;
            for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                PointcutPattern pp = ppr.getPointcutPattern();
                if (pp == null || pp.getBeanIdPattern() == null && pp.getClassNamePattern() == null && pp.getMethodNamePattern() == null) continue;
                aspectRule.setBeanRelevant(true);
                continue block0;
            }
        }
    }

    public void setPointcutPatternVerifiable(boolean pointcutPatternVerifiable) {
        this.pointcutPatternVerifiable = pointcutPatternVerifiable;
    }

    public void register(@NonNull BeanRuleRegistry beanRuleRegistry) {
        for (BeanRule beanRule : beanRuleRegistry.getConfigurableBeanRules()) {
            if (beanRule.getProxied() != null || beanRule.isFactoryable()) continue;
            this.determineProxyBean(beanRule);
        }
        for (BeanRule beanRule : beanRuleRegistry.getIdBasedBeanRules()) {
            if (beanRule.getProxied() != null || beanRule.isFactoryable()) continue;
            this.determineProxyBean(beanRule);
        }
        for (Set set : beanRuleRegistry.getTypeBasedBeanRules()) {
            for (BeanRule beanRule : set) {
                if (beanRule.getProxied() != null || beanRule.isFactoryable()) continue;
                this.determineProxyBean(beanRule);
            }
        }
    }

    private void determineProxyBean(@NonNull BeanRule beanRule) {
        Class<?> beanClass = beanRule.getTargetBeanClass();
        if (beanClass.isAnnotationPresent(AvoidAdvice.class)) {
            beanRule.setProxied(false);
            return;
        }
        for (AspectRule aspectRule : this.aspectRuleRegistry.getAspectRules()) {
            Pointcut pointcut;
            if (!aspectRule.isBeanRelevant() || (pointcut = aspectRule.getPointcut()) == null || !this.existsMatchedBean(pointcut, beanRule)) continue;
            beanRule.setProxied(true);
            break;
        }
    }

    public void register(@NonNull TransletRuleRegistry transletRuleRegistry) {
        for (TransletRule transletRule : transletRuleRegistry.getTransletRules()) {
            if (transletRule.hasPathVariables()) continue;
            this.register(transletRule);
        }
    }

    private void register(TransletRule transletRule) {
        for (AspectRule aspectRule : this.aspectRuleRegistry.getAspectRules()) {
            Pointcut pointcut = aspectRule.getPointcut();
            if (aspectRule.isBeanRelevant() || pointcut != null && !pointcut.matches(transletRule.getName())) continue;
            transletRule.touchAspectAdviceRuleRegistry().register(aspectRule);
        }
    }

    private boolean existsMatchedBean(@NonNull Pointcut pointcut, BeanRule beanRule) {
        boolean exists = false;
        List<PointcutPatternRule> pointcutPatternRuleList = pointcut.getPointcutPatternRuleList();
        if (pointcutPatternRuleList != null) {
            String beanId = beanRule.getId();
            String className = beanRule.getTargetBeanClassName();
            String[] methodNames = null;
            if (pointcut.hasMethodNamePattern()) {
                BeanDescriptor bd = BeanDescriptor.getInstance(beanRule.getTargetBeanClass());
                methodNames = bd.getDistinctMethodNames();
            }
            for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                if (!this.existsBean(pointcut, ppr, beanId, className, methodNames)) continue;
                exists = true;
                if (this.pointcutPatternVerifiable) continue;
                break;
            }
        }
        return exists;
    }

    private boolean existsBean(Pointcut pointcut, @NonNull PointcutPatternRule pointcutPatternRule, String beanId, String className, String[] methodNames) {
        boolean matched = true;
        PointcutPattern pp = pointcutPatternRule.getPointcutPattern();
        if (pp != null && pp.getBeanIdPattern() != null && (matched = pointcut.patternMatches(pp.getBeanIdPattern(), beanId, '.'))) {
            pointcutPatternRule.increaseMatchedBeanIdCount();
        }
        if (matched && pp != null && pp.getClassNamePattern() != null && (matched = pointcut.patternMatches(pp.getClassNamePattern(), className, '.'))) {
            pointcutPatternRule.increaseMatchedClassNameCount();
        }
        if (matched && methodNames != null && pp != null && pp.getMethodNamePattern() != null) {
            matched = false;
            for (String methodName : methodNames) {
                boolean matched2 = pointcut.patternMatches(pp.getMethodNamePattern(), methodName);
                if (!matched2) continue;
                pointcutPatternRule.increaseMatchedMethodNameCount();
                matched = true;
                break;
            }
        }
        return matched;
    }
}

