/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.core.component.aspect.pointcut.Pointcut;
import com.aspectran.core.component.aspect.pointcut.PointcutPattern;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.List;

public abstract class AbstractPointcut
implements Pointcut {
    private final List<PointcutPatternRule> pointcutPatternRuleList;
    private final boolean existsMethodNamePattern;

    public AbstractPointcut(List<PointcutPatternRule> pointcutPatternRuleList) {
        this.pointcutPatternRuleList = pointcutPatternRuleList;
        if (pointcutPatternRuleList != null) {
            boolean existsMethodNamePattern = false;
            for (PointcutPatternRule ppr : pointcutPatternRuleList) {
                PointcutPattern pp = ppr.getPointcutPattern();
                if (pp == null || pp.getMethodNamePattern() == null) continue;
                existsMethodNamePattern = true;
                break;
            }
            this.existsMethodNamePattern = existsMethodNamePattern;
        } else {
            this.existsMethodNamePattern = false;
        }
    }

    @Override
    public List<PointcutPatternRule> getPointcutPatternRuleList() {
        return this.pointcutPatternRuleList;
    }

    @Override
    public boolean hasMethodNamePattern() {
        return this.existsMethodNamePattern;
    }

    @Override
    public boolean matches(String transletName) {
        return this.matches(transletName, null, null, null);
    }

    @Override
    public boolean matches(String transletName, String beanId, String className) {
        return this.matches(transletName, beanId, className, null);
    }

    @Override
    public boolean matches(String transletName, String beanId, String className, String methodName) {
        if (this.pointcutPatternRuleList != null) {
            for (PointcutPatternRule ppr : this.pointcutPatternRuleList) {
                if (!this.exists(ppr, transletName, beanId, className, methodName)) continue;
                List<PointcutPatternRule> epprList = ppr.getExcludePointcutPatternRuleList();
                if (epprList != null) {
                    for (PointcutPatternRule eppr : epprList) {
                        if (!this.exists(eppr, transletName, beanId, className, methodName)) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean matches(@NonNull PointcutPattern pointcutPattern) {
        return this.matches(pointcutPattern.getTransletNamePattern(), pointcutPattern.getBeanIdPattern(), pointcutPattern.getClassNamePattern(), pointcutPattern.getMethodNamePattern());
    }

    @Override
    public boolean exists(String transletName) {
        return this.exists(transletName, null, null, null);
    }

    @Override
    public boolean exists(String transletName, String beanId, String className) {
        return this.exists(transletName, beanId, className, null);
    }

    @Override
    public boolean exists(String transletName, String beanId, String className, String methodName) {
        if (this.pointcutPatternRuleList != null) {
            for (PointcutPatternRule ppr : this.pointcutPatternRuleList) {
                if (!this.exists(ppr, transletName, beanId, className, methodName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean exists(PointcutPattern pointcutPattern) {
        if (pointcutPattern == null) {
            throw new IllegalArgumentException("pointcutPattern must not be null");
        }
        return this.exists(pointcutPattern.getTransletNamePattern(), pointcutPattern.getBeanIdPattern(), pointcutPattern.getClassNamePattern(), pointcutPattern.getMethodNamePattern());
    }

    protected boolean exists(PointcutPatternRule pointcutPatternRule, String transletName, String beanId, String className, String methodName) {
        if (pointcutPatternRule == null) {
            throw new IllegalArgumentException("pointcutPatternRule must not be null");
        }
        boolean matched = true;
        PointcutPattern pp = pointcutPatternRule.getPointcutPattern();
        if (pp != null && pp.getTransletNamePattern() != null) {
            matched = this.patternMatches(pp.getTransletNamePattern(), transletName, '/');
        }
        if (matched && pp != null && pp.getBeanIdPattern() != null) {
            matched = this.patternMatches(pp.getBeanIdPattern(), beanId, '.');
        }
        if (matched && pp != null && pp.getClassNamePattern() != null) {
            matched = this.patternMatches(pp.getClassNamePattern(), className, '.');
        }
        if (matched && pp != null && pp.getMethodNamePattern() != null) {
            matched = this.patternMatches(pp.getMethodNamePattern(), methodName);
        }
        return matched;
    }
}

