/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.Objects;

public class PointcutPattern {
    private static final char POINTCUT_BEAN_NAME_DELIMITER = '@';
    private static final char POINTCUT_METHOD_NAME_DELIMITER = '^';
    private final String transletNamePattern;
    private final String beanIdPattern;
    private final String classNamePattern;
    private final String methodNamePattern;
    private volatile int hashCode;

    public PointcutPattern(String transletNamePattern, String beanIdPattern, String classNamePattern, String methodNamePattern) {
        this.transletNamePattern = transletNamePattern;
        this.beanIdPattern = beanIdPattern;
        this.classNamePattern = classNamePattern;
        this.methodNamePattern = methodNamePattern;
    }

    public String getTransletNamePattern() {
        return this.transletNamePattern;
    }

    public String getBeanIdPattern() {
        return this.beanIdPattern;
    }

    public String getClassNamePattern() {
        return this.classNamePattern;
    }

    public String getMethodNamePattern() {
        return this.methodNamePattern;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PointcutPattern)) {
            return false;
        }
        PointcutPattern that = (PointcutPattern)other;
        return Objects.equals(this.transletNamePattern, that.getTransletNamePattern()) && Objects.equals(this.beanIdPattern, that.getBeanIdPattern()) && Objects.equals(this.classNamePattern, that.getClassNamePattern()) && Objects.equals(this.methodNamePattern, that.getMethodNamePattern());
    }

    public int hashCode() {
        int prime = 31;
        int result = this.hashCode;
        if (result == 0) {
            result = 11;
            result = 31 * result + (this.transletNamePattern != null ? this.transletNamePattern.hashCode() : 0);
            result = 31 * result + (this.beanIdPattern != null ? this.beanIdPattern.hashCode() : 0);
            result = 31 * result + (this.classNamePattern != null ? this.classNamePattern.hashCode() : 0);
            this.hashCode = result = 31 * result + (this.methodNamePattern != null ? this.methodNamePattern.hashCode() : 0);
        }
        return result;
    }

    public String toString() {
        return PointcutPattern.combinePattern(this);
    }

    @NonNull
    public static String combinePattern(@NonNull PointcutPattern pointcutPattern) {
        return PointcutPattern.combinePattern(pointcutPattern.getTransletNamePattern(), pointcutPattern.getBeanIdPattern(), pointcutPattern.getClassNamePattern(), pointcutPattern.getMethodNamePattern());
    }

    @NonNull
    public static String combinePattern(String transletName, String beanId, String className, String methodName) {
        int len = 0;
        if (transletName != null && !transletName.isEmpty()) {
            len += transletName.length();
        }
        if (beanId != null && !beanId.isEmpty()) {
            len += beanId.length() + 1;
        } else if (className != null && !className.isEmpty()) {
            len += className.length() + 7;
        }
        if (methodName != null && !methodName.isEmpty()) {
            len += methodName.length() + 1;
        }
        StringBuilder sb = new StringBuilder(len);
        if (transletName != null && !transletName.isEmpty()) {
            sb.append(transletName);
        }
        if (beanId != null && !beanId.isEmpty()) {
            sb.append('@');
            sb.append(beanId);
        } else if (className != null && !className.isEmpty()) {
            sb.append('@');
            sb.append("class:");
            sb.append(className);
        }
        if (methodName != null && !methodName.isEmpty()) {
            sb.append('^');
            sb.append(methodName);
        }
        return sb.toString();
    }

    @NonNull
    public static PointcutPattern parsePattern(@NonNull String patternString) {
        String transletNamePattern = null;
        String beanNamePattern = null;
        String methodNamePattern = null;
        int beanNameDelimiterIndex = patternString.indexOf(64);
        if (beanNameDelimiterIndex == -1) {
            transletNamePattern = patternString;
        } else if (beanNameDelimiterIndex == 0) {
            beanNamePattern = patternString.substring(1);
        } else {
            transletNamePattern = patternString.substring(0, beanNameDelimiterIndex);
            beanNamePattern = patternString.substring(beanNameDelimiterIndex + 1);
        }
        if (beanNamePattern != null) {
            int methodNameDelimiterIndex = beanNamePattern.indexOf(94);
            if (methodNameDelimiterIndex == 0) {
                methodNamePattern = beanNamePattern.substring(1);
                beanNamePattern = null;
            } else if (methodNameDelimiterIndex > 0) {
                methodNamePattern = beanNamePattern.substring(methodNameDelimiterIndex + 1);
                beanNamePattern = beanNamePattern.substring(0, methodNameDelimiterIndex);
            }
        }
        String beanIdPattern = null;
        String classNamePattern = null;
        if (beanNamePattern != null) {
            if (beanNamePattern.startsWith("class:")) {
                classNamePattern = beanNamePattern.substring("class:".length());
            } else {
                beanIdPattern = beanNamePattern;
            }
        }
        return new PointcutPattern(transletNamePattern, beanIdPattern, classNamePattern, methodNamePattern);
    }
}

