/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.core.component.aspect.pointcut.AbstractPointcut;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.utils.cache.Cache;
import com.aspectran.utils.cache.ConcurrentReferenceCache;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexpPointcut
extends AbstractPointcut {
    private final Cache<String, Pattern> cache = new ConcurrentReferenceCache<String, Pattern>(Pattern::compile);

    public RegexpPointcut(List<PointcutPatternRule> pointcutPatternRuleList) {
        super(pointcutPatternRuleList);
    }

    @Override
    public boolean patternMatches(String patternString, String compareString) {
        if (patternString == null) {
            throw new IllegalArgumentException("regex must not be null");
        }
        Pattern pattern = this.cache.get(patternString);
        Matcher matcher = pattern.matcher(compareString);
        return matcher.matches();
    }

    @Override
    public boolean patternMatches(String patternString, String compareString, char separator) {
        return this.patternMatches(patternString, compareString);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

