/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.aspect.pointcut;

import com.aspectran.core.component.aspect.pointcut.AbstractPointcut;
import com.aspectran.core.context.rule.PointcutPatternRule;
import com.aspectran.utils.ConcurrentReferenceHashMap;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.wildcard.WildcardPattern;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class WildcardPointcut
extends AbstractPointcut {
    private static final String OR_MATCH_DELIMITER = "|";
    private final Map<String, WildcardPattern> cache = new ConcurrentReferenceHashMap<String, WildcardPattern>();

    public WildcardPointcut(List<PointcutPatternRule> pointcutPatternRuleList) {
        super(pointcutPatternRuleList);
    }

    @Override
    public boolean patternMatches(String patternString, String compareString) {
        if (patternString == null) {
            throw new IllegalArgumentException("patternString must not be null");
        }
        if (patternString.contains(OR_MATCH_DELIMITER)) {
            StringTokenizer parser = new StringTokenizer(patternString, OR_MATCH_DELIMITER);
            while (parser.hasMoreTokens()) {
                if (!this.wildcardPatternMatches(parser.nextToken(), compareString)) continue;
                return true;
            }
            return false;
        }
        return this.wildcardPatternMatches(patternString, compareString);
    }

    @Override
    public boolean patternMatches(String patternString, String compareString, char separator) {
        if (patternString == null) {
            throw new IllegalArgumentException("patternString must not be null");
        }
        if (patternString.contains(OR_MATCH_DELIMITER)) {
            StringTokenizer parser = new StringTokenizer(patternString, OR_MATCH_DELIMITER);
            while (parser.hasMoreTokens()) {
                if (!this.wildcardPatternMatches(parser.nextToken(), compareString, separator)) continue;
                return true;
            }
            return false;
        }
        return this.wildcardPatternMatches(patternString, compareString, separator);
    }

    private boolean wildcardPatternMatches(String patternString, String compareString) {
        WildcardPattern existing;
        if (!WildcardPattern.hasWildcards(patternString)) {
            return patternString.equals(compareString);
        }
        WildcardPattern wildcardPattern = this.cache.get(patternString);
        if (wildcardPattern == null && (existing = this.cache.putIfAbsent(patternString, wildcardPattern = new WildcardPattern(patternString))) != null) {
            wildcardPattern = existing;
        }
        return wildcardPattern.matches(compareString);
    }

    private boolean wildcardPatternMatches(@NonNull String patternString, String compareString, char separator) {
        WildcardPattern existing;
        if (patternString.indexOf(separator) == -1 && !WildcardPattern.hasWildcards(patternString)) {
            return patternString.equals(compareString);
        }
        String patternKey = patternString + separator;
        WildcardPattern wildcardPattern = this.cache.get(patternKey);
        if (wildcardPattern == null && (existing = this.cache.putIfAbsent(patternKey, wildcardPattern = new WildcardPattern(patternString, separator))) != null) {
            wildcardPattern = existing;
        }
        return wildcardPattern.matches(compareString);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }
}

