/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.process.action.AnnotatedAction;
import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.bean.BeanCreationException;
import com.aspectran.core.component.bean.BeanFactoryUtils;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.FactoryBeanNotInitializedException;
import com.aspectran.core.component.bean.NoSuchBeanException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.component.bean.ablility.FactoryBean;
import com.aspectran.core.component.bean.ablility.InitializableBean;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.component.bean.aware.ApplicationAdapterAware;
import com.aspectran.core.component.bean.aware.Aware;
import com.aspectran.core.component.bean.aware.CurrentActivityAware;
import com.aspectran.core.component.bean.aware.EnvironmentAware;
import com.aspectran.core.component.bean.proxy.ProxyBeanFactory;
import com.aspectran.core.component.bean.scope.Scope;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.asel.value.ValueExpression;
import com.aspectran.core.context.rule.AutowireRule;
import com.aspectran.core.context.rule.AutowireTargetRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ItemRule;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.core.context.rule.ItemRuleUtils;
import com.aspectran.core.context.rule.ParameterBindingRule;
import com.aspectran.core.context.rule.type.AutowireTargetType;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.ReflectionUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;

abstract class AbstractBeanFactory
extends AbstractComponent {
    private static final Logger logger = LoggerFactory.getLogger(AbstractBeanFactory.class);
    private final ActivityContext context;
    private final ProxyBeanFactory proxyBeanFactory;

    AbstractBeanFactory(ActivityContext context) {
        this.context = context;
        this.proxyBeanFactory = new ProxyBeanFactory(context);
    }

    protected ActivityContext getActivityContext() {
        return this.context;
    }

    protected Object createBean(BeanRule beanRule) {
        return this.createBean(beanRule, null);
    }

    protected Object createBean(@NonNull BeanRule beanRule, Scope scope) {
        Activity activity = this.context.getAvailableActivity();
        Object bean = beanRule.isFactoryOffered() ? this.createOfferedFactoryBean(beanRule, scope, activity) : this.createNormalBean(beanRule, scope, activity);
        return bean;
    }

    protected Object getFactoryProducedObject(@NonNull BeanRule beanRule, Object bean) {
        if (beanRule.isFactoryBean()) {
            return this.invokeMethodOfFactoryBean(beanRule, bean);
        }
        if (beanRule.getFactoryMethodName() != null) {
            Activity activity = this.context.getAvailableActivity();
            return this.invokeFactoryMethod(beanRule, bean, activity);
        }
        return null;
    }

    private Object createNormalBean(@NonNull BeanRule beanRule, Scope scope, Activity activity) {
        try {
            Object value;
            Class<?>[] argTypes;
            Object[] args;
            ItemRuleMap ctorArgumentItemRuleMap = beanRule.getConstructorArgumentItemRuleMap();
            if (ctorArgumentItemRuleMap != null && !ctorArgumentItemRuleMap.isEmpty()) {
                Map<String, Object> valueMap = activity.getItemEvaluator().evaluate(ctorArgumentItemRuleMap);
                args = new Object[ctorArgumentItemRuleMap.size()];
                argTypes = new Class[ctorArgumentItemRuleMap.size()];
                int i = 0;
                for (Map.Entry entry : ctorArgumentItemRuleMap.entrySet()) {
                    args[i] = value = valueMap.get(entry.getKey());
                    argTypes[i] = ItemRuleUtils.getPrototypeClass((ItemRule)entry.getValue(), value);
                    ++i;
                }
            } else {
                AutowireRule ctorAutowireRule = beanRule.getConstructorAutowireRule();
                AutowireTargetRule[] autowireTargetRules = AutowireRule.getAutowireTargetRules(ctorAutowireRule);
                if (autowireTargetRules != null) {
                    args = new Object[autowireTargetRules.length];
                    argTypes = new Class[autowireTargetRules.length];
                    for (int i = 0; i < autowireTargetRules.length; ++i) {
                        Class<?> type = autowireTargetRules[i].getType();
                        ValueExpression valueEvaluator = autowireTargetRules[i].getValueExpression();
                        if (valueEvaluator != null) {
                            args[i] = valueEvaluator.evaluate(activity, null);
                            if (ctorAutowireRule.isRequired() && args[i] == null) {
                                throw new BeanCreationException("Could not autowire constructor: " + String.valueOf(ctorAutowireRule), beanRule);
                            }
                        } else {
                            String qualifier = autowireTargetRules[i].getQualifier();
                            if (ctorAutowireRule.isRequired()) {
                                try {
                                    args[i] = activity.getBean(type, qualifier);
                                }
                                catch (NoSuchBeanException | NoUniqueBeanException e) {
                                    logger.error("No bean found for autowiring target " + String.valueOf(autowireTargetRules[i]) + " of " + String.valueOf(ctorAutowireRule), e);
                                    throw new BeanCreationException("Could not autowire constructor: " + String.valueOf(ctorAutowireRule), beanRule, e);
                                }
                            }
                            try {
                                args[i] = activity.getBean(type, qualifier);
                            }
                            catch (NoSuchBeanException | NoUniqueBeanException e) {
                                args[i] = null;
                                logger.warn("No bean found for autowiring target " + String.valueOf(autowireTargetRules[i]) + " of " + String.valueOf(ctorAutowireRule) + "; Cause: " + String.valueOf(e));
                            }
                        }
                        argTypes[i] = type;
                    }
                } else {
                    args = MethodUtils.EMPTY_OBJECT_ARRAY;
                    argTypes = MethodUtils.EMPTY_CLASS_PARAMETERS;
                }
            }
            Object bean = this.instantiateBean(beanRule, args, argTypes);
            if (scope != null) {
                scope.putBeanInstance(activity, beanRule, new BeanInstance(bean));
            }
            this.invokeAwareMethods(bean);
            this.autowiring(beanRule, bean, activity);
            ItemRuleMap propertyItemRuleMap = beanRule.getPropertyItemRuleMap();
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                for (Map.Entry entry : propertyItemRuleMap.entrySet()) {
                    value = activity.getItemEvaluator().evaluate((ItemRule)entry.getValue());
                    MethodUtils.invokeSetter(bean, (String)entry.getKey(), value);
                }
            }
            if (beanRule.isInitializableBean()) {
                this.initializeBean(beanRule, bean);
            } else if (beanRule.getInitMethod() != null) {
                this.invokeInitMethod(beanRule, bean, activity);
            }
            return bean;
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException(beanRule, (Throwable)e);
        }
    }

    private Object createOfferedFactoryBean(@NonNull BeanRule beanRule, Scope scope, Activity activity) {
        Object bean;
        String factoryBeanId = beanRule.getFactoryBeanId();
        Class<?> factoryBeanClass = beanRule.getFactoryBeanClass();
        try {
            bean = factoryBeanClass != null ? (Modifier.isInterface(factoryBeanClass.getModifiers()) ? null : activity.getBean(factoryBeanClass)) : activity.getBean(factoryBeanId);
            bean = this.invokeFactoryMethod(beanRule, bean, activity);
            if (bean == null) {
                throw new NullPointerException("Factory Method [" + String.valueOf(beanRule.getFactoryMethod()) + "] has returned null");
            }
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while invoking a factory method from the offered factory bean", beanRule, e);
        }
        if (scope != null) {
            scope.putBeanInstance(activity, beanRule, new BeanInstance(bean));
        }
        try {
            ItemRuleMap propertyItemRuleMap = beanRule.getPropertyItemRuleMap();
            if (propertyItemRuleMap != null && !propertyItemRuleMap.isEmpty()) {
                for (Map.Entry entry : propertyItemRuleMap.entrySet()) {
                    Object value = activity.getItemEvaluator().evaluate((ItemRule)entry.getValue());
                    MethodUtils.invokeSetter(bean, (String)entry.getKey(), value);
                }
            }
            if (beanRule.getInitMethod() != null) {
                this.invokeInitMethod(beanRule, bean, activity);
            }
            return bean;
        }
        catch (BeanCreationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BeanCreationException(beanRule, (Throwable)e);
        }
    }

    private Object instantiateBean(@NonNull BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        Object bean = beanRule.isProxied() ? this.proxyBeanFactory.createProxy(beanRule, args, argTypes) : (args != null ? BeanFactoryUtils.newInstance(beanRule.getBeanClass(), args, argTypes) : BeanFactoryUtils.newInstance(beanRule.getBeanClass()));
        return bean;
    }

    private void autowiring(@NonNull BeanRule beanRule, Object bean, Activity activity) {
        if (beanRule.getAutowireRuleList() != null) {
            for (AutowireRule autowireRule : beanRule.getAutowireRuleList()) {
                AutowireTargetRule[] autowireTargetRules;
                AutowireTargetRule autowireTargetRule;
                if (autowireRule.getTargetType() == AutowireTargetType.FIELD) {
                    Object value;
                    autowireTargetRule = AutowireRule.getAutowireTargetRule(autowireRule);
                    if (autowireTargetRule == null) continue;
                    ValueExpression valueEvaluator = autowireTargetRule.getValueExpression();
                    if (valueEvaluator != null) {
                        value = valueEvaluator.evaluate(activity, null);
                    } else {
                        Class<?> type = autowireTargetRule.getType();
                        String qualifier = autowireTargetRule.getQualifier();
                        if (autowireRule.isRequired()) {
                            try {
                                value = activity.getBean(type, qualifier);
                            }
                            catch (NoSuchBeanException | NoUniqueBeanException e) {
                                logger.error("No bean found for autowiring target " + String.valueOf(autowireTargetRule) + " of " + String.valueOf(autowireRule), e);
                                throw new BeanCreationException("Could not autowire field: " + String.valueOf(autowireRule), beanRule, e);
                            }
                        }
                        try {
                            value = activity.getBean(type, qualifier);
                        }
                        catch (NoSuchBeanException | NoUniqueBeanException e) {
                            value = null;
                            logger.warn("No bean found for autowiring target " + String.valueOf(autowireTargetRule) + " of " + String.valueOf(autowireRule) + "; Cause: " + String.valueOf(e));
                        }
                    }
                    ReflectionUtils.setField((Field)autowireRule.getTarget(), bean, value);
                    continue;
                }
                if (autowireRule.getTargetType() == AutowireTargetType.FIELD_VALUE) {
                    ValueExpression valueEvaluator;
                    autowireTargetRule = AutowireRule.getAutowireTargetRule(autowireRule);
                    if (autowireTargetRule == null || (valueEvaluator = autowireTargetRule.getValueExpression()) == null) continue;
                    Object value = valueEvaluator.evaluate(activity, null);
                    ReflectionUtils.setField((Field)autowireRule.getTarget(), bean, value);
                    continue;
                }
                if (autowireRule.getTargetType() != AutowireTargetType.METHOD || (autowireTargetRules = autowireRule.getAutowireTargetRules()) == null) continue;
                Object[] args = new Object[autowireTargetRules.length];
                for (int i = 0; i < autowireTargetRules.length; ++i) {
                    ValueExpression valueEvaluator = autowireTargetRules[i].getValueExpression();
                    if (valueEvaluator != null) {
                        args[i] = valueEvaluator.evaluate(activity, null);
                        if (!autowireRule.isRequired() || args[i] != null) continue;
                        throw new BeanCreationException("Autowiring failed for method: " + String.valueOf(autowireRule), beanRule);
                    }
                    Class<?> type = autowireTargetRules[i].getType();
                    String qualifier = autowireTargetRules[i].getQualifier();
                    if (autowireRule.isRequired()) {
                        try {
                            args[i] = activity.getBean(type, qualifier);
                            continue;
                        }
                        catch (NoSuchBeanException | NoUniqueBeanException e) {
                            logger.error("No bean found for autowiring target " + String.valueOf(autowireTargetRules[i]) + " of " + String.valueOf(autowireRule), e);
                            throw new BeanCreationException("Could not autowire method: " + String.valueOf(autowireRule), beanRule, e);
                        }
                    }
                    try {
                        args[i] = activity.getBean(type, qualifier);
                        continue;
                    }
                    catch (NoSuchBeanException | NoUniqueBeanException e) {
                        args[i] = null;
                        logger.warn("No bean found for autowiring target " + String.valueOf(autowireTargetRules[i]) + " of " + String.valueOf(autowireRule) + "; Cause: " + String.valueOf(e));
                    }
                }
                ReflectionUtils.invokeMethod((Method)autowireRule.getTarget(), bean, args);
            }
        }
    }

    private void invokeAwareMethods(Object bean) {
        if (bean instanceof Aware) {
            if (bean instanceof CurrentActivityAware) {
                CurrentActivityAware currentActivityAware = (CurrentActivityAware)bean;
                if (this.context.hasCurrentActivity()) {
                    currentActivityAware.setCurrentActivity(this.context.getCurrentActivity());
                }
            }
            if (bean instanceof ActivityContextAware) {
                ActivityContextAware activityContextAware = (ActivityContextAware)bean;
                activityContextAware.setActivityContext(this.context);
            }
            if (bean instanceof ApplicationAdapterAware) {
                ApplicationAdapterAware applicationAdapterAware = (ApplicationAdapterAware)bean;
                applicationAdapterAware.setApplicationAdapter(this.context.getApplicationAdapter());
            }
            if (bean instanceof EnvironmentAware) {
                EnvironmentAware environmentAware = (EnvironmentAware)bean;
                environmentAware.setEnvironment(this.context.getEnvironment());
            }
        }
    }

    private void initializeBean(BeanRule beanRule, Object bean) {
        try {
            ((InitializableBean)bean).initialize();
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while initialization of bean", beanRule, e);
        }
    }

    private void invokeInitMethod(BeanRule beanRule, Object bean, Activity activity) {
        try {
            Method initMethod = beanRule.getInitMethod();
            ParameterBindingRule[] parameterBindingRules = beanRule.getInitMethodParameterBindingRules();
            AnnotatedAction.invokeMethod(activity, bean, initMethod, parameterBindingRules);
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while executing an initialization method of bean", beanRule, e);
        }
    }

    private Object invokeFactoryMethod(BeanRule beanRule, Object bean, Activity activity) {
        try {
            Method factoryMethod = beanRule.getFactoryMethod();
            ParameterBindingRule[] parameterBindingRules = beanRule.getFactoryMethodParameterBindingRules();
            return AnnotatedAction.invokeMethod(activity, bean, factoryMethod, parameterBindingRules);
        }
        catch (Exception e) {
            throw new BeanCreationException("An exception occurred while executing a factory method of bean", beanRule, e);
        }
    }

    @NonNull
    private Object invokeMethodOfFactoryBean(BeanRule beanRule, Object bean) {
        Object resultBean;
        try {
            resultBean = ((FactoryBean)bean).getObject();
        }
        catch (Exception e) {
            throw new BeanCreationException("FactoryBean threw exception on object creation", beanRule, e);
        }
        if (resultBean == null) {
            throw new FactoryBeanNotInitializedException("FactoryBean returned null object: probably not fully initialized (maybe due to circular bean reference)", beanRule);
        }
        return resultBean;
    }
}

