/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.component.bean.BeanInstantiationException;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.ReflectionUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;

public abstract class BeanFactoryUtils {
    @NonNull
    public static Object newInstance(@NonNull Class<?> beanClass, Object[] args, Class<?>[] argTypes) {
        Constructor<?> constructorToUse;
        if (beanClass.isInterface()) {
            throw new BeanInstantiationException(beanClass, "Specified class is an interface");
        }
        try {
            constructorToUse = BeanFactoryUtils.getMatchConstructor(beanClass, args);
            if (constructorToUse == null) {
                constructorToUse = ClassUtils.findConstructor(beanClass, argTypes);
            }
        }
        catch (NoSuchMethodException e) {
            throw new BeanInstantiationException(beanClass, "No default constructor found", e);
        }
        return BeanFactoryUtils.newInstance(constructorToUse, args);
    }

    @NonNull
    public static Object newInstance(Class<?> beanClass) {
        return BeanFactoryUtils.newInstance(beanClass, MethodUtils.EMPTY_OBJECT_ARRAY, MethodUtils.EMPTY_CLASS_PARAMETERS);
    }

    @NonNull
    private static Object newInstance(@NonNull Constructor<?> ctor, Object[] args) {
        try {
            if (ObjectUtils.isEmpty(args)) {
                return ctor.newInstance(args);
            }
            Class<?>[] parameterTypes = ctor.getParameterTypes();
            boolean casting = false;
            for (Class<?> clazz : parameterTypes) {
                if (!clazz.isArray()) continue;
                casting = true;
                break;
            }
            if (casting) {
                Object[] newArgs = Arrays.copyOf(args, args.length);
                for (int i = 0; i < parameterTypes.length; ++i) {
                    Object object = newArgs[i];
                    if (!(object instanceof Object[])) continue;
                    Object[] arr = (Object[])object;
                    Class<?> clazz = parameterTypes[i];
                    Class<?> componentType = clazz.getComponentType();
                    int len = arr.length;
                    Object[] newArr = (Object[])Array.newInstance(componentType, len);
                    System.arraycopy(arr, 0, newArr, 0, len);
                    newArgs[i] = newArr;
                }
                return ctor.newInstance(newArgs);
            }
            return ctor.newInstance(args);
        }
        catch (InstantiationException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Is it an abstract class?", e);
        }
        catch (IllegalAccessException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Has the class definition changed? Is the constructor accessible?", e);
        }
        catch (IllegalArgumentException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Illegal arguments for constructor " + String.valueOf(ctor), e);
        }
        catch (InvocationTargetException e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", e.getTargetException());
        }
        catch (Exception e) {
            throw new BeanInstantiationException(ctor.getDeclaringClass(), "Constructor threw exception", e);
        }
    }

    private static Constructor<?> getMatchConstructor(@NonNull Class<?> beanClass, Object[] args) {
        Constructor<?>[] candidates = beanClass.getDeclaredConstructors();
        Constructor<?> constructorToUse = null;
        float bestMatchWeight = Float.MAX_VALUE;
        for (Constructor<?> candidate : candidates) {
            float matchWeight = ReflectionUtils.getTypeDifferenceWeight(candidate.getParameterTypes(), args);
            if (!(matchWeight < bestMatchWeight)) continue;
            constructorToUse = candidate;
            bestMatchWeight = matchWeight;
        }
        return constructorToUse;
    }
}

