/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.component.bean.AbstractBeanRegistry;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.component.bean.BeanRuleRegistry;
import com.aspectran.core.component.bean.NoSuchBeanException;
import com.aspectran.core.component.bean.NoUniqueBeanException;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.service.CoreService;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.util.Collection;

public class DefaultBeanRegistry
extends AbstractBeanRegistry {
    public DefaultBeanRegistry(ActivityContext context, BeanRuleRegistry beanRuleRegistry) {
        super(context, beanRuleRegistry);
    }

    @Override
    public <V> V getBean(String id) {
        BeanRule beanRule = this.getBeanRuleRegistry().getBeanRule(id);
        if (beanRule == null) {
            BeanRegistry parent = this.getParentBeanRegistry();
            if (parent != null) {
                return parent.getBean(id);
            }
            throw new NoSuchBeanException(id);
        }
        return this.getBean(beanRule);
    }

    @Override
    public <V> V getBean(Class<V> type) {
        return this.getBean(type, null);
    }

    @Override
    public <V> V getBean(Class<V> type, @Nullable String id) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(type);
        if (beanRules == null) {
            BeanRule beanRule = this.getBeanRuleRegistry().getBeanRuleForConfig(type);
            if (beanRule != null) {
                return this.getBean(beanRule);
            }
            BeanRegistry parent = this.getParentBeanRegistry();
            if (parent != null) {
                return parent.getBean(type, id);
            }
            if (id != null) {
                throw new NoSuchBeanException(type, id);
            }
            throw new NoSuchBeanException(type);
        }
        if (beanRules.length == 1) {
            if (id != null) {
                if (id.equals(beanRules[0].getId())) {
                    return this.getBean(beanRules[0]);
                }
                BeanRegistry parent = this.getParentBeanRegistry();
                if (parent != null) {
                    return parent.getBean(type, id);
                }
                throw new NoSuchBeanException(type, id);
            }
            return this.getBean(beanRules[0]);
        }
        if (id != null) {
            for (BeanRule beanRule : beanRules) {
                if (!id.equals(beanRule.getId())) continue;
                return this.getBean(beanRule);
            }
            BeanRegistry parent = this.getParentBeanRegistry();
            if (parent != null) {
                return parent.getBean(type, id);
            }
            throw new NoSuchBeanException(type, id);
        }
        BeanRegistry parent = this.getParentBeanRegistry();
        if (parent != null) {
            return parent.getBean(type, null);
        }
        throw new NoUniqueBeanException(type, beanRules);
    }

    @Override
    public <V> V[] getBeansOfType(Class<V> type) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(type);
        if (beanRules != null) {
            Object arr = Array.newInstance(type, beanRules.length);
            for (int i = 0; i < beanRules.length; ++i) {
                Object bean = this.getBean(beanRules[i]);
                Array.set(arr, i, bean);
            }
            return (Object[])arr;
        }
        BeanRegistry parent = this.getParentBeanRegistry();
        if (parent != null) {
            return parent.getBeansOfType(type);
        }
        return null;
    }

    @Override
    public boolean containsBean(String id) {
        if (this.getBeanRuleRegistry().containsBeanRule(id)) {
            return true;
        }
        BeanRegistry parent = this.getParentBeanRegistry();
        if (parent != null) {
            return parent.containsBean(id);
        }
        return false;
    }

    @Override
    public boolean containsBean(Class<?> type) {
        if (this.getBeanRuleRegistry().containsBeanRule(type)) {
            return true;
        }
        BeanRegistry parent = this.getParentBeanRegistry();
        if (parent != null) {
            return parent.containsBean(type);
        }
        return false;
    }

    @Override
    public boolean containsBean(Class<?> type, @Nullable String id) {
        BeanRule[] beanRules = this.getBeanRuleRegistry().getBeanRules(type);
        if (beanRules == null) {
            BeanRegistry parent = this.getParentBeanRegistry();
            if (parent != null) {
                return parent.containsBean(type, id);
            }
            return false;
        }
        if (beanRules.length == 1) {
            if (id != null) {
                if (id.equals(beanRules[0].getId())) {
                    return true;
                }
                BeanRegistry parent = this.getParentBeanRegistry();
                if (parent != null) {
                    return parent.containsBean(type, id);
                }
                return false;
            }
            return true;
        }
        if (id != null) {
            for (BeanRule beanRule : beanRules) {
                if (!id.equals(beanRule.getId())) continue;
                return true;
            }
            BeanRegistry parent = this.getParentBeanRegistry();
            if (parent != null) {
                return parent.containsBean(type, id);
            }
            return false;
        }
        return true;
    }

    @Override
    public Collection<Class<?>> findConfigBeanClassesWithAnnotation(Class<? extends Annotation> annotationType) {
        return this.getBeanRuleRegistry().findConfigBeanClassesWithAnnotation(annotationType);
    }

    @Nullable
    private BeanRegistry getParentBeanRegistry() {
        CoreService parentService;
        if (this.getActivityContext().getMasterService() != null && (parentService = this.getActivityContext().getMasterService().getParentService()) != null) {
            return parentService.getActivityContext().getBeanRegistry();
        }
        return null;
    }
}

