/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean;

import com.aspectran.core.component.bean.BeanException;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class NoUniqueBeanException
extends BeanException {
    private static final long serialVersionUID = 8350428939010030065L;
    private final Class<?> type;
    private final BeanRule[] beanRules;

    public NoUniqueBeanException(Class<?> type, @NonNull BeanRule[] beanRules) {
        super("No qualifying bean of type '" + String.valueOf(type) + "' is defined: expected single matching bean but found " + beanRules.length + ": [" + NoUniqueBeanException.getBeanDescriptions(beanRules) + "]");
        this.type = type;
        this.beanRules = beanRules;
    }

    public Class<?> getType() {
        return this.type;
    }

    public BeanRule[] getBeanRules() {
        return this.beanRules;
    }

    public static String getBeanDescriptions(@NonNull BeanRule[] beanRules) {
        String[] describes = new String[beanRules.length];
        for (int i = 0; i < describes.length; ++i) {
            describes[i] = beanRules[i].toString();
        }
        return StringUtils.joinCommaDelimitedList(describes);
    }
}

