/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.proxy;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.aspect.AdviceConstraintViolationException;
import com.aspectran.core.activity.aspect.AspectAdviceException;
import com.aspectran.core.activity.process.action.ActionExecutionException;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.aspect.AspectRuleRegistry;
import com.aspectran.core.component.aspect.RelevantAspectRuleHolder;
import com.aspectran.core.component.aspect.pointcut.PointcutPattern;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.context.rule.AspectAdviceRule;
import com.aspectran.core.context.rule.AspectRule;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.ExceptionRule;
import com.aspectran.core.context.rule.SettingsAdviceRule;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.lang.reflect.Method;
import java.util.List;

public abstract class AbstractBeanProxy {
    private final AspectRuleRegistry aspectRuleRegistry;

    public AbstractBeanProxy(AspectRuleRegistry aspectRuleRegistry) {
        this.aspectRuleRegistry = aspectRuleRegistry;
    }

    protected boolean isAvoidAdvice(@NonNull Method method) {
        return Object.class == method.getDeclaringClass() || method.getDeclaringClass().isAnnotationPresent(AvoidAdvice.class) || method.isAnnotationPresent(AvoidAdvice.class);
    }

    protected AspectAdviceRuleRegistry getAspectAdviceRuleRegistry(@NonNull Activity activity, String beanId, String className, String methodName) throws AdviceConstraintViolationException, AspectAdviceException {
        boolean literalPattern;
        String requestName;
        if (activity.hasTranslet()) {
            requestName = activity.getTranslet().getRequestName();
            literalPattern = !activity.getTranslet().hasPathVariables();
        } else {
            requestName = null;
            literalPattern = true;
        }
        PointcutPattern pointcutPattern = new PointcutPattern(requestName, beanId, className, methodName);
        RelevantAspectRuleHolder holder = literalPattern ? this.aspectRuleRegistry.getRelevantAspectRuleHolderFromSoftCache(pointcutPattern) : this.aspectRuleRegistry.getRelevantAspectRuleHolderFromWeakCache(pointcutPattern);
        AspectAdviceRuleRegistry aarr = holder.getAspectAdviceRuleRegistry();
        if (aarr != null && aarr.getSettingsAdviceRuleList() != null) {
            for (SettingsAdviceRule sar : aarr.getSettingsAdviceRuleList()) {
                activity.registerSettingsAdviceRule(sar);
            }
        }
        if (holder.getDynamicAspectRuleList() != null) {
            for (AspectRule aspectRule : holder.getDynamicAspectRuleList()) {
                activity.registerAspectAdviceRule(aspectRule);
            }
        }
        return aarr;
    }

    protected void beforeAdvice(List<AspectAdviceRule> beforeAdviceRuleList, BeanRule beanRule, Activity activity) throws AspectAdviceException {
        if (beforeAdviceRuleList != null) {
            for (AspectAdviceRule aspectAdviceRule : beforeAdviceRuleList) {
                if (this.isSameBean(beanRule, aspectAdviceRule)) continue;
                activity.executeAdvice(aspectAdviceRule, true);
            }
        }
    }

    protected void afterAdvice(List<AspectAdviceRule> afterAdviceRuleList, BeanRule beanRule, Activity activity) throws AspectAdviceException {
        if (afterAdviceRuleList != null) {
            for (AspectAdviceRule aspectAdviceRule : afterAdviceRuleList) {
                if (this.isSameBean(beanRule, aspectAdviceRule)) continue;
                activity.executeAdvice(aspectAdviceRule, true);
            }
        }
    }

    protected void finallyAdvice(List<AspectAdviceRule> finallyAdviceRuleList, BeanRule beanRule, Activity activity) throws AspectAdviceException {
        if (finallyAdviceRuleList != null) {
            for (AspectAdviceRule aspectAdviceRule : finallyAdviceRuleList) {
                if (this.isSameBean(beanRule, aspectAdviceRule)) continue;
                activity.executeAdvice(aspectAdviceRule, false);
            }
        }
    }

    protected boolean exceptionally(List<ExceptionRule> exceptionRuleList, Exception exception, @NonNull Activity activity) throws ActionExecutionException {
        activity.setRaisedException(exception);
        if (exceptionRuleList != null) {
            activity.handleException(exceptionRuleList);
            return activity.isResponseReserved();
        }
        return false;
    }

    private boolean isSameBean(@NonNull BeanRule beanRule, AspectAdviceRule aspectAdviceRule) {
        if (beanRule.getId() != null && beanRule.getId().equals(aspectAdviceRule.getAdviceBeanId())) {
            return true;
        }
        if (beanRule.getBeanClass() != null && aspectAdviceRule.getAdviceBeanClass() != null) {
            return beanRule.getBeanClass() == aspectAdviceRule.getAdviceBeanClass();
        }
        return false;
    }
}

