/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.proxy;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.InstantActivity;
import com.aspectran.core.activity.InstantActivityException;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.bean.proxy.AbstractBeanProxy;
import com.aspectran.core.component.bean.proxy.BeanProxyException;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;

public class JavassistBeanProxy
extends AbstractBeanProxy
implements MethodHandler {
    private final ActivityContext context;
    private final BeanRule beanRule;

    private JavassistBeanProxy(@NonNull ActivityContext context, @NonNull BeanRule beanRule) {
        super(context.getAspectRuleRegistry());
        this.context = context;
        this.beanRule = beanRule;
    }

    public Object invoke(Object self, Method overridden, Method proceed, Object[] args) throws Throwable {
        if (this.isAvoidAdvice(overridden)) {
            return proceed.invoke(self, args);
        }
        if (this.context.hasCurrentActivity()) {
            Activity activity = this.context.getCurrentActivity();
            return this.invoke(self, overridden, proceed, args, activity);
        }
        try {
            InstantActivity activity = new InstantActivity(this.context);
            return activity.perform(() -> this.invoke(self, overridden, proceed, args, activity));
        }
        catch (Exception e) {
            throw new InstantActivityException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object invoke(Object self, @NonNull Method overridden, Method proceed, Object[] args, Activity activity) throws Throwable {
        Object object;
        String methodName;
        String className;
        String beanId = this.beanRule.getId();
        AspectAdviceRuleRegistry aarr = this.getAspectAdviceRuleRegistry(activity, beanId, className = this.beanRule.getClassName(), methodName = overridden.getName());
        if (aarr == null) {
            return this.invokeSuper(self, proceed, args);
        }
        try {
            this.beforeAdvice(aarr.getBeforeAdviceRuleList(), this.beanRule, activity);
            Object result = this.invokeSuper(self, proceed, args);
            this.afterAdvice(aarr.getAfterAdviceRuleList(), this.beanRule, activity);
            object = result;
        }
        catch (Throwable throwable) {
            try {
                this.finallyAdvice(aarr.getFinallyAdviceRuleList(), this.beanRule, activity);
                throw throwable;
            }
            catch (Exception e) {
                if (this.exceptionally(aarr.getExceptionRuleList(), e, activity)) {
                    return null;
                }
                throw e;
            }
        }
        this.finallyAdvice(aarr.getFinallyAdviceRuleList(), this.beanRule, activity);
        return object;
    }

    private Object invokeSuper(Object self, @NonNull Method proceed, Object[] args) throws Throwable {
        try {
            return proceed.invoke(self, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    public static Object create(ActivityContext context, BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        try {
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setSuperclass(beanRule.getBeanClass());
            JavassistBeanProxy methodHandler = new JavassistBeanProxy(context, beanRule);
            return proxyFactory.create((Class[])argTypes, args, (MethodHandler)methodHandler);
        }
        catch (Exception e) {
            throw new BeanProxyException(beanRule, (Throwable)e);
        }
    }
}

