/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.proxy;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.component.aspect.AspectAdviceRuleRegistry;
import com.aspectran.core.component.bean.BeanFactoryUtils;
import com.aspectran.core.component.bean.proxy.AbstractBeanProxy;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public class JdkBeanProxy
extends AbstractBeanProxy
implements InvocationHandler {
    private final ActivityContext context;
    private final BeanRule beanRule;
    private final Object bean;

    private JdkBeanProxy(@NonNull ActivityContext context, @NonNull BeanRule beanRule, @NonNull Object bean) {
        super(context.getAspectRuleRegistry());
        this.context = context;
        this.beanRule = beanRule;
        this.bean = bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object object;
        String methodName;
        String className;
        String beanId;
        if (this.isAvoidAdvice(method)) {
            return method.invoke(this.bean, args);
        }
        Activity activity = this.context.getAvailableActivity();
        AspectAdviceRuleRegistry aarr = this.getAspectAdviceRuleRegistry(activity, beanId = this.beanRule.getId(), className = this.beanRule.getClassName(), methodName = method.getName());
        if (aarr == null) {
            return this.invokeSuper(method, args);
        }
        try {
            this.beforeAdvice(aarr.getBeforeAdviceRuleList(), this.beanRule, activity);
            Object result = this.invokeSuper(method, args);
            this.afterAdvice(aarr.getAfterAdviceRuleList(), this.beanRule, activity);
            object = result;
        }
        catch (Throwable throwable) {
            try {
                this.finallyAdvice(aarr.getFinallyAdviceRuleList(), this.beanRule, activity);
                throw throwable;
            }
            catch (Exception e) {
                if (this.exceptionally(aarr.getExceptionRuleList(), e, activity)) {
                    return null;
                }
                throw e;
            }
        }
        this.finallyAdvice(aarr.getFinallyAdviceRuleList(), this.beanRule, activity);
        return object;
    }

    private Object invokeSuper(@NonNull Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.bean, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    @NonNull
    public static Object create(ActivityContext context, BeanRule beanRule, Object[] args, Class<?>[] argTypes) {
        Object bean = argTypes != null && args != null ? BeanFactoryUtils.newInstance(beanRule.getBeanClass(), args, argTypes) : BeanFactoryUtils.newInstance(beanRule.getBeanClass());
        JdkBeanProxy proxy = new JdkBeanProxy(context, beanRule, bean);
        return Proxy.newProxyInstance(context.getAvailableActivity().getClassLoader(), beanRule.getBeanClass().getInterfaces(), (InvocationHandler)proxy);
    }
}

