/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.scan;

import com.aspectran.core.component.bean.scan.BeanClassFilter;
import com.aspectran.core.component.bean.scan.BeanClassScanException;
import com.aspectran.utils.ClassScanner;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.wildcard.WildcardPattern;
import java.lang.reflect.Modifier;

public class BeanClassScanner
extends ClassScanner {
    private static final Logger logger = LoggerFactory.getLogger(BeanClassScanner.class);
    private BeanClassFilter beanClassFilter;
    private WildcardPattern beanIdMaskPattern;
    private WildcardPattern[] excludePatterns;

    public BeanClassScanner(ClassLoader classLoader) {
        super(classLoader);
    }

    public void setBeanClassFilter(BeanClassFilter beanClassFilter) {
        this.beanClassFilter = beanClassFilter;
    }

    public void setExcludePatterns(String[] excludePatterns) {
        if (excludePatterns != null && excludePatterns.length > 0) {
            this.excludePatterns = new WildcardPattern[excludePatterns.length];
            for (int i = 0; i < excludePatterns.length; ++i) {
                WildcardPattern pattern;
                this.excludePatterns[i] = pattern = new WildcardPattern(excludePatterns[i], '.');
            }
        } else {
            this.excludePatterns = null;
        }
    }

    public void setBeanIdMaskPattern(String beanIdMaskPattern) {
        if (beanIdMaskPattern == null) {
            throw new IllegalArgumentException("beanIdMaskPattern must not be null");
        }
        this.beanIdMaskPattern = new WildcardPattern(beanIdMaskPattern, '.');
    }

    @Override
    public void scan(String classNamePattern, ClassScanner.SaveHandler saveHandler) {
        try {
            super.scan(classNamePattern, new BeanSaveHandler(saveHandler));
        }
        catch (Exception e) {
            throw new BeanClassScanException("Failed to scan bean classes with given pattern: " + classNamePattern, e);
        }
    }

    private class BeanSaveHandler
    implements ClassScanner.SaveHandler {
        private final ClassScanner.SaveHandler saveHandler;

        public BeanSaveHandler(ClassScanner.SaveHandler saveHandler) {
            this.saveHandler = saveHandler;
        }

        @Override
        public void save(@NonNull String resourceName, @NonNull Class<?> targetClass) {
            String className;
            if (!Modifier.isPublic(targetClass.getModifiers()) || !Modifier.isInterface(targetClass.getModifiers()) && Modifier.isAbstract(targetClass.getModifiers())) {
                return;
            }
            String beanId = className = targetClass.getName();
            if (BeanClassScanner.this.beanIdMaskPattern != null) {
                String maskedBeanId = BeanClassScanner.this.beanIdMaskPattern.mask(beanId);
                if (maskedBeanId != null) {
                    beanId = maskedBeanId;
                } else {
                    logger.warn("Bean name [" + beanId + "] can not be masked by mask pattern [" + String.valueOf(BeanClassScanner.this.beanIdMaskPattern) + "]");
                }
            }
            if (BeanClassScanner.this.beanClassFilter != null && (beanId = BeanClassScanner.this.beanClassFilter.filter(beanId, resourceName, targetClass)) == null) {
                return;
            }
            if (BeanClassScanner.this.excludePatterns != null) {
                for (WildcardPattern pattern : BeanClassScanner.this.excludePatterns) {
                    if (!pattern.matches(className)) continue;
                    return;
                }
            }
            this.saveHandler.save(beanId, targetClass);
            if (logger.isTraceEnabled()) {
                logger.trace(String.format("Scanned bean {id=%s, class=%s}", beanId, className));
            }
        }
    }
}

