/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.scope;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.scope.Scope;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.utils.Assert;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;

public abstract class AbstractScope
implements Scope {
    private static final Logger logger = LoggerFactory.getLogger(AbstractScope.class);
    private final Map<BeanRule, BeanInstance> scopedBeanInstances = new LinkedHashMap<BeanRule, BeanInstance>();

    protected Map<BeanRule, BeanInstance> getScopedBeanInstances() {
        return this.scopedBeanInstances;
    }

    @Override
    public BeanInstance getBeanInstance(BeanRule beanRule) {
        return this.scopedBeanInstances.get(beanRule);
    }

    @Override
    public void putBeanInstance(Activity activity, BeanRule beanRule, BeanInstance beanInstance) {
        Assert.notNull((Object)activity, "activity must not be null");
        Assert.notNull((Object)beanRule, "beanRule must not be null");
        Assert.notNull((Object)beanInstance, "beanInstance must not be null");
        this.scopedBeanInstances.put(beanRule, beanInstance);
    }

    @Override
    public BeanRule getBeanRuleByInstance(Object bean) {
        Assert.notNull(bean, "bean must not be null");
        for (Map.Entry<BeanRule, BeanInstance> entry : this.scopedBeanInstances.entrySet()) {
            if (entry.getValue().getBean() != bean) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public boolean containsBeanRule(BeanRule beanRule) {
        return this.scopedBeanInstances.containsKey(beanRule);
    }

    @Override
    public void destroy(Object bean) throws Exception {
        BeanRule beanRule = this.getBeanRuleByInstance(bean);
        if (beanRule != null) {
            this.doDestroy(beanRule, bean);
            this.scopedBeanInstances.remove(beanRule);
        }
    }

    @Override
    public void destroy() {
        Object bean;
        BeanInstance instance;
        if (logger.isDebugEnabled() && !this.scopedBeanInstances.isEmpty()) {
            logger.debug("Destroy " + String.valueOf((Object)this.getScopeType()) + " scoped beans from " + String.valueOf(this));
        }
        ArrayList<BeanRule> targets = new ArrayList<BeanRule>(this.scopedBeanInstances.keySet());
        ArrayList<BeanRule> remainders = new ArrayList<BeanRule>();
        ListIterator iter = targets.listIterator(targets.size());
        while (iter.hasPrevious()) {
            BeanRule beanRule = (BeanRule)iter.previous();
            instance = this.scopedBeanInstances.get(beanRule);
            bean = instance.getBean();
            if (bean == null) continue;
            if (beanRule.isLazyDestroy()) {
                remainders.add(beanRule);
                continue;
            }
            try {
                this.doDestroy(beanRule, bean);
            }
            catch (Exception e) {
                logger.error("Could not destroy " + String.valueOf((Object)this.getScopeType()) + " scoped bean " + String.valueOf(beanRule), e);
            }
        }
        for (BeanRule beanRule : remainders) {
            instance = this.scopedBeanInstances.get(beanRule);
            bean = instance.getBean();
            if (bean == null) continue;
            try {
                this.doDestroy(beanRule, bean);
            }
            catch (Exception e) {
                logger.error("Could not destroy " + String.valueOf((Object)this.getScopeType()) + " scoped bean " + String.valueOf(beanRule), e);
            }
        }
        this.scopedBeanInstances.clear();
    }

    private void doDestroy(BeanRule beanRule, Object bean) throws Exception {
        if (bean != null) {
            if (beanRule.isDisposableBean()) {
                ((DisposableBean)bean).destroy();
            } else if (beanRule.getDestroyMethodName() != null) {
                Method destroyMethod = beanRule.getDestroyMethod();
                destroyMethod.invoke(bean, MethodUtils.EMPTY_OBJECT_ARRAY);
            }
        }
    }
}

