/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.bean.scope;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.component.bean.BeanInstance;
import com.aspectran.core.component.bean.scope.AbstractScope;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionBindingListener;
import com.aspectran.core.context.rule.BeanRule;
import com.aspectran.core.context.rule.type.ScopeType;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SessionScope
extends AbstractScope
implements SessionBindingListener {
    private static final ScopeType scopeType = ScopeType.SESSION;
    private final ReadWriteLock scopeLock = new ReentrantReadWriteLock();
    public static final String SESSION_SCOPE_ATTR_NAME = SessionScope.class.getName();

    @Override
    public ScopeType getScopeType() {
        return scopeType;
    }

    @Override
    public ReadWriteLock getScopeLock() {
        return this.scopeLock;
    }

    @Override
    public void valueUnbound(Session session, String name, Object value) {
        this.destroy();
    }

    @Override
    public BeanInstance getBeanInstance(BeanRule beanRule) {
        BeanInstance beanInstance = super.getBeanInstance(beanRule);
        if (beanInstance == null) {
            BeanRule matchingBeanRule = this.findMatchingBeanRule(beanRule);
            beanInstance = super.getBeanInstance(matchingBeanRule);
        }
        return beanInstance;
    }

    @Override
    public void putBeanInstance(Activity activity, BeanRule beanRule, BeanInstance beanInstance) {
        BeanRule matchingBeanRule = this.findMatchingBeanRule(beanRule);
        if (matchingBeanRule == null) {
            matchingBeanRule = beanRule;
        }
        super.putBeanInstance(activity, matchingBeanRule, beanInstance);
    }

    @Override
    public BeanRule getBeanRuleByInstance(Object bean) {
        throw new UnsupportedOperationException("Not available in session scope; Because it may be created in another JVM");
    }

    @Override
    public boolean containsBeanRule(BeanRule beanRule) {
        return this.findMatchingBeanRule(beanRule) != null;
    }

    @Nullable
    private BeanRule findMatchingBeanRule(BeanRule beanRule) {
        for (Map.Entry<BeanRule, BeanInstance> entry : this.getScopedBeanInstances().entrySet()) {
            BeanRule target = entry.getKey();
            if (beanRule.getId() != null && beanRule.getId().equals(target.getId())) {
                return target;
            }
            String className = beanRule.getTargetBeanClassName();
            if (className == null || !className.equals(target.getTargetBeanClassName())) continue;
            return target;
        }
        return null;
    }
}

