/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.ManagedSession;
import com.aspectran.core.component.session.SessionCache;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionStatistics;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.component.session.UnreadableSessionDataException;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

public abstract class AbstractSessionCache
extends AbstractComponent
implements SessionCache {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionCache.class);
    private final AbstractSessionHandler sessionHandler;
    private final SessionStore sessionStore;
    private final boolean clusterEnabled;
    private final String thisName;
    private final String storeName;
    private int evictionIdleSecs = -1;
    private boolean saveOnCreate;
    private boolean saveOnInactiveEviction;
    private boolean removeUnloadableSessions;

    public AbstractSessionCache(AbstractSessionHandler sessionHandler, SessionStore sessionStore, boolean clusterEnabled) {
        this.sessionHandler = sessionHandler;
        this.sessionStore = sessionStore;
        this.clusterEnabled = clusterEnabled && sessionStore != null;
        this.thisName = ObjectUtils.simpleIdentityToString(this);
        this.storeName = ObjectUtils.simpleIdentityToString(sessionStore);
    }

    protected SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    protected SessionStore getSessionStore() {
        return this.sessionStore;
    }

    protected String getSessionStoreName() {
        return this.storeName;
    }

    protected SessionStatistics getStatistics() {
        return this.sessionHandler.getStatistics();
    }

    @Override
    public boolean isClusterEnabled() {
        return this.clusterEnabled;
    }

    @Override
    public int getEvictionIdleSecs() {
        return this.evictionIdleSecs;
    }

    @Override
    public void setEvictionIdleSecs(int evictionTimeout) {
        this.checkInitializable();
        this.evictionIdleSecs = evictionTimeout;
    }

    @Override
    public boolean isSaveOnCreate() {
        return this.saveOnCreate;
    }

    @Override
    public void setSaveOnCreate(boolean saveOnCreate) {
        this.checkInitializable();
        this.saveOnCreate = saveOnCreate;
    }

    @Override
    public boolean isSaveOnInactiveEviction() {
        return this.saveOnInactiveEviction;
    }

    @Override
    public void setSaveOnInactiveEviction(boolean saveOnEvict) {
        this.checkInitializable();
        this.saveOnInactiveEviction = saveOnEvict;
    }

    @Override
    public boolean isRemoveUnloadableSessions() {
        return this.removeUnloadableSessions;
    }

    @Override
    public void setRemoveUnloadableSessions(boolean removeUnloadableSessions) {
        this.checkInitializable();
        this.removeUnloadableSessions = removeUnloadableSessions;
    }

    @Override
    public ManagedSession get(String id) throws Exception {
        return this.get(id, false);
    }

    @Nullable
    private ManagedSession get(String id, boolean forDeleting) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        AtomicBoolean loaded = new AtomicBoolean(false);
        AtomicReference thrown = new AtomicReference();
        ManagedSession session = this.doComputeIfAbsent(id, k -> {
            if (logger.isTraceEnabled()) {
                logger.trace("Session " + id + " not found locally in " + String.valueOf(this) + ", attempting to load");
            }
            try {
                ManagedSession stored = this.loadSession(id);
                if (stored != null) {
                    try (AutoLock ignored = stored.lock();){
                        stored.setResident(true);
                    }
                    loaded.set(true);
                } else if (logger.isTraceEnabled()) {
                    logger.trace("Session " + id + " not loaded by " + this.storeName);
                }
                return stored;
            }
            catch (Exception e) {
                thrown.set(e);
                return null;
            }
        });
        if (thrown.get() != null) {
            throw (Exception)thrown.get();
        }
        if (!forDeleting && session != null && loaded.get()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Residing evicted session id=" + session.getId() + " into " + this.thisName);
            }
            this.sessionHandler.onSessionResided(session);
        }
        return session;
    }

    @Nullable
    private ManagedSession loadSession(String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (this.sessionStore == null) {
            return null;
        }
        try {
            SessionData data = this.sessionStore.load(id);
            if (data != null) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Session " + id + " loaded from session store " + String.valueOf(this.sessionStore));
                }
                return new ManagedSession(this.sessionHandler, data, false);
            }
            return null;
        }
        catch (UnreadableSessionDataException e) {
            if (this.isRemoveUnloadableSessions()) {
                this.sessionStore.delete(id);
            }
            throw e;
        }
    }

    @Override
    public ManagedSession add(String id, long time, long maxInactiveInterval) throws Exception {
        SessionData data;
        ManagedSession session;
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Create new session id=" + id);
        }
        if (this.doPutIfAbsent(id, session = new ManagedSession(this.sessionHandler, data = new SessionData(id, time, time, time, maxInactiveInterval), true)) == null) {
            session.setResident(true);
            if (this.sessionStore != null && (this.isSaveOnCreate() || this.isClusterEnabled())) {
                this.sessionStore.save(id, data);
            }
            return session;
        }
        throw new IllegalStateException("Session " + id + " already in " + this.thisName);
    }

    @Override
    public void refresh(ManagedSession session) throws Exception {
        block13: {
            if (session == null) {
                throw new IllegalArgumentException("session must not be null");
            }
            if (!this.isClusterEnabled() || this.sessionStore == null) {
                return;
            }
            String id = session.getId();
            try (AutoLock ignored = session.lock();){
                if (session.getRequests() > 0L) break block13;
                try {
                    SessionData data = this.sessionStore.load(id);
                    if (data != null) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Reload session data for session id=" + id + " from " + this.storeName);
                        }
                        session.setSessionData(data);
                    }
                }
                catch (UnreadableSessionDataException e) {
                    if (this.isRemoveUnloadableSessions()) {
                        this.sessionStore.delete(id);
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    public void release(ManagedSession session) throws Exception {
        if (session == null) {
            throw new IllegalArgumentException("session must not be null");
        }
        String id = session.getId();
        try (AutoLock ignored = session.lock();){
            if (!session.isValid()) {
                return;
            }
            if (session.getRequests() <= 0L) {
                if (this.sessionStore != null) {
                    this.sessionStore.save(id, session.getSessionData());
                } else if (logger.isTraceEnabled()) {
                    logger.trace("No SessionStore, session in " + this.thisName + " only id=" + id);
                }
                if (this.getEvictionIdleSecs() == 0) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Eviction on request exit id=" + id);
                    }
                    this.doDelete(session.getId());
                    session.setResident(false);
                } else {
                    session.setResident(true);
                    this.doPutIfAbsent(id, session);
                }
            } else {
                session.setResident(true);
                this.doPutIfAbsent(id, session);
            }
        }
    }

    @Override
    public boolean exists(String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        if (this.isClusterEnabled()) {
            ManagedSession session = this.get(id, false);
            if (session != null) {
                return session.isValid();
            }
            return false;
        }
        ManagedSession session = this.doGet(id);
        if (session != null) {
            return session.isValid();
        }
        return this.sessionStore != null && this.sessionStore.exists(id);
    }

    @Override
    public boolean contains(String id) throws Exception {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        return this.doGet(id) != null;
    }

    @Override
    public ManagedSession delete(String id) throws Exception {
        ManagedSession session = this.get(id, true);
        if (this.sessionStore != null) {
            boolean deleted = this.sessionStore.delete(id);
            if (logger.isTraceEnabled()) {
                logger.trace("Session " + id + " deleted in " + this.storeName + ": " + deleted);
            }
        }
        if (session != null) {
            session.setResident(false);
        }
        return this.doDelete(id);
    }

    protected abstract ManagedSession doGet(String var1);

    protected abstract ManagedSession doPutIfAbsent(String var1, ManagedSession var2);

    protected abstract ManagedSession doComputeIfAbsent(String var1, Function<String, ManagedSession> var2);

    protected abstract ManagedSession doDelete(String var1);

    @Override
    public ManagedSession renewSessionId(String oldId, String newId) throws Exception {
        if (!StringUtils.hasText(oldId)) {
            throw new IllegalArgumentException("Old session id is null");
        }
        if (!StringUtils.hasText(newId)) {
            throw new IllegalArgumentException("New session id is null");
        }
        ManagedSession session = this.get(oldId, false);
        if (session != null) {
            this.renewSessionId(session, newId);
        }
        return session;
    }

    protected void renewSessionId(@NonNull ManagedSession session, @NonNull String newId) throws Exception {
        try (AutoLock ignored = session.lock();){
            String oldId = session.getId();
            session.checkValidForWrite();
            session.getSessionData().setId(newId);
            session.getSessionData().setLastSaved(0L);
            session.getSessionData().setDirty(true);
            this.doPutIfAbsent(newId, session);
            this.doDelete(oldId);
            if (this.sessionStore != null) {
                this.sessionStore.delete(oldId);
                this.sessionStore.save(newId, session.getSessionData());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Session id " + oldId + " swapped for new id " + newId);
            }
        }
    }

    @Override
    public Set<String> checkExpiration(Set<String> candidates) {
        Set<String> allCandidates;
        if (!this.isInitialized()) {
            return null;
        }
        if (this.sessionStore == null) {
            return candidates;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("SessionStore checking expiration on " + String.valueOf(candidates));
        }
        if ((allCandidates = this.sessionStore.getExpired(candidates)) != null) {
            HashSet<String> sessionsInUse = new HashSet<String>();
            for (String id : allCandidates) {
                ManagedSession session = this.doGet(id);
                if (session == null || session.getRequests() <= 0L) continue;
                sessionsInUse.add(id);
            }
            if (!sessionsInUse.isEmpty()) {
                try {
                    allCandidates.removeAll(sessionsInUse);
                }
                catch (UnsupportedOperationException e) {
                    HashSet<String> tmp = new HashSet<String>(allCandidates);
                    tmp.removeAll(sessionsInUse);
                    allCandidates = tmp;
                }
            }
        }
        return allCandidates;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean checkInactiveSession(ManagedSession session) {
        if (session == null) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Checking for idle session id=" + session.getId());
        }
        try (AutoLock ignored = session.lock();){
            if (this.getEvictionIdleSecs() <= 0) return false;
            if (!session.isIdleLongerThan(this.getEvictionIdleSecs())) return false;
            if (!session.isValid()) return false;
            if (!session.isResident()) return false;
            if (session.getRequests() > 0L) return false;
            if (logger.isDebugEnabled()) {
                logger.debug("Evicting idle session id=" + session.getId() + " from " + this.thisName);
            }
            if (this.sessionStore != null && (this.isClusterEnabled() || this.isSaveOnInactiveEviction())) {
                this.sessionStore.save(session.getId(), session.getSessionData());
            }
            this.doDelete(session.getId());
            session.setResident(false);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.warn("Passivation of idle session " + session.getId() + " failed", e);
        }
        return false;
    }

    @Override
    public void cleanOrphans(long time) {
        if (this.sessionStore != null) {
            this.sessionStore.cleanOrphans(time);
        }
    }
}

