/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.HouseKeeper;
import com.aspectran.core.component.session.ManagedSession;
import com.aspectran.core.component.session.MaxSessionsExceededException;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionCache;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionIdGenerator;
import com.aspectran.core.component.session.SessionListener;
import com.aspectran.core.component.session.SessionStatistics;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;
import com.aspectran.utils.thread.Scheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractSessionHandler
extends AbstractComponent
implements SessionHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionHandler.class);
    private final SessionStatistics statistics = new SessionStatistics();
    private final List<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();
    private final Set<String> candidateSessionIdsForExpiry = ConcurrentHashMap.newKeySet();
    private String workerName;
    private Scheduler scheduler;
    private SessionIdGenerator sessionIdGenerator;
    private SessionCache sessionCache;
    private HouseKeeper houseKeeper;
    private volatile int defaultMaxIdleSecs = 1800;
    private long lastOrphanSweepTime = 0L;

    AbstractSessionHandler() {
    }

    public abstract ClassLoader getClassLoader();

    @Override
    public String getWorkerName() {
        return this.workerName;
    }

    protected void setWorkerName(String workerName) {
        if (this.workerName != null) {
            throw new IllegalStateException("workerName already set");
        }
        if (workerName != null && workerName.contains(".")) {
            throw new IllegalArgumentException("Worker name cannot contain '.'");
        }
        this.workerName = workerName;
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    protected void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public SessionIdGenerator getSessionIdGenerator() {
        return this.sessionIdGenerator;
    }

    protected void setSessionIdGenerator(SessionIdGenerator sessionIdGenerator) {
        this.sessionIdGenerator = sessionIdGenerator;
    }

    @Override
    public SessionCache getSessionCache() {
        return this.sessionCache;
    }

    protected void setSessionCache(SessionCache sessionCache) {
        this.sessionCache = sessionCache;
    }

    public HouseKeeper getHouseKeeper() {
        return this.houseKeeper;
    }

    protected void setHouseKeeper(HouseKeeper houseKeeper) {
        this.houseKeeper = houseKeeper;
    }

    @Override
    public int getDefaultMaxIdleSecs() {
        return this.defaultMaxIdleSecs;
    }

    @Override
    public void setDefaultMaxIdleSecs(int defaultMaxIdleSecs) {
        this.defaultMaxIdleSecs = defaultMaxIdleSecs;
        if (logger.isDebugEnabled()) {
            if (defaultMaxIdleSecs <= 0) {
                logger.debug("Sessions created by this manager are immortal (default maxInactiveInterval=" + defaultMaxIdleSecs + ")");
            } else {
                logger.debug("SessionHandler default maxInactiveInterval=" + defaultMaxIdleSecs);
            }
        }
    }

    @Override
    public ManagedSession getSession(String id) {
        ManagedSession session = null;
        try {
            session = this.sessionCache.get(id);
            if (session != null && session.isExpiredAt(System.currentTimeMillis())) {
                try {
                    session.setDestroyedReason(Session.DestroyedReason.TIMEOUT);
                    session.invalidate();
                }
                catch (Exception e) {
                    logger.warn("Invalidating session " + id + " found to be expired when requested", e);
                }
                return null;
            }
            return session;
        }
        catch (Exception e) {
            if (session != null && session.isValid()) {
                logger.warn(e);
            }
            return null;
        }
    }

    @Override
    public ManagedSession createSession(String id) {
        long now = System.currentTimeMillis();
        long maxInactiveInterval = this.defaultMaxIdleSecs > 0 ? (long)this.defaultMaxIdleSecs * 1000L : -1L;
        try {
            ManagedSession session = this.sessionCache.add(id, now, maxInactiveInterval);
            this.getStatistics().sessionCreated();
            this.onSessionCreated(session);
            return session;
        }
        catch (MaxSessionsExceededException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create new session id=" + id, e);
        }
    }

    protected void refreshSession(ManagedSession session) {
        try {
            this.sessionCache.refresh(session);
        }
        catch (Exception e) {
            logger.warn("Session refresh failed", e);
        }
    }

    protected void releaseSession(ManagedSession session) {
        try {
            this.sessionCache.release(session);
        }
        catch (Exception e) {
            logger.warn("Session release failed", e);
        }
    }

    @Override
    public String createSessionId(long seedTerm) {
        return this.sessionIdGenerator.createSessionId(seedTerm);
    }

    @Override
    public String renewSessionId(String oldId, String newId) {
        try {
            ManagedSession session = this.sessionCache.renewSessionId(oldId, newId);
            if (session == null) {
                return null;
            }
            for (SessionListener listener : this.sessionListeners) {
                listener.sessionIdChanged(session, oldId);
            }
            return session.getId();
        }
        catch (Exception e) {
            logger.warn("Unable to renew session id " + oldId + " to " + newId, e);
            return null;
        }
    }

    @Override
    public ManagedSession removeSession(String id, boolean invalidate) {
        return this.removeSession(id, invalidate, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagedSession removeSession(String id, boolean invalidate, Session.DestroyedReason reason) {
        if (!StringUtils.hasText(id)) {
            return null;
        }
        try {
            ManagedSession session;
            block20: {
                session = this.sessionCache.delete(id);
                if (invalidate && session != null) {
                    try {
                        if (!session.beginInvalidate()) break block20;
                        try (AutoLock ignored = session.lock();){
                            if (reason != null) {
                                session.setDestroyedReason(reason);
                            }
                            this.onSessionDestroyed(session);
                        }
                        catch (Exception e) {
                            logger.warn("Error during Session destroy listener", e);
                        }
                        finally {
                            session.finishInvalidate();
                        }
                    }
                    catch (IllegalStateException e) {
                        if (!logger.isDebugEnabled()) break block20;
                        logger.debug("Session " + String.valueOf(session) + " already invalid");
                    }
                }
            }
            return session;
        }
        catch (Exception e) {
            if (invalidate) {
                logger.warn("Unable to invalidate session id=" + id, e);
            } else {
                logger.warn("Unable to remove session id=" + id, e);
            }
            return null;
        }
    }

    @Override
    public void invalidate(String id) {
        this.removeSession(id, true);
    }

    @Override
    public void invalidate(String id, Session.DestroyedReason reason) {
        this.removeSession(id, true, reason);
    }

    public boolean sessionInactivityTimerExpired(ManagedSession session, long now) {
        if (session == null) {
            return true;
        }
        try (AutoLock ignored = session.lock();){
            if (session.isExpiredAt(now)) {
                if (!this.addCandidateSessionIdForExpiry(session.getId())) {
                    this.invalidate(session.getId(), Session.DestroyedReason.TIMEOUT);
                }
                boolean bl = true;
                return bl;
            }
            boolean evicted = this.sessionCache.checkInactiveSession(session);
            if (evicted) {
                this.addCandidateSessionIdForExpiry(session.getId());
                this.onSessionEvicted(session);
            }
            boolean bl = false;
            return bl;
        }
    }

    private boolean addCandidateSessionIdForExpiry(String id) {
        if (this.getHouseKeeper() != null && this.getHouseKeeper().isRunning()) {
            this.candidateSessionIdsForExpiry.add(id);
            if (logger.isTraceEnabled()) {
                logger.trace("Session " + id + " is candidate for expiry");
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scavenge(long scavengingInterval) {
        if (this.isDestroying() || this.isDestroyed()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(this.getComponentName() + " scavenging sessions");
        }
        String[] candidateSessionIds = this.candidateSessionIdsForExpiry.toArray(new String[0]);
        HashSet<String> candidates = new HashSet<String>(Arrays.asList(candidateSessionIds));
        if (logger.isTraceEnabled()) {
            logger.trace(this.getComponentName() + " scavenging session ids " + String.valueOf(candidates));
        }
        try {
            Set<String> checkedCandidates = this.sessionCache.checkExpiration(candidates);
            if (checkedCandidates != null) {
                for (String id : checkedCandidates) {
                    this.candidateSessionIdsForExpiry.remove(id);
                    this.invalidate(id, Session.DestroyedReason.TIMEOUT);
                }
            }
            if (logger.isDebugEnabled()) {
                int before = candidates.size();
                int after = this.candidateSessionIdsForExpiry.size();
                int scavenged = checkedCandidates != null ? checkedCandidates.size() : 0;
                int unmanaged = scavenged - before + after;
                if (scavenged != 0 || unmanaged != 0) {
                    ToStringBuilder tsb = new ToStringBuilder("Scavenging status for expired sessions");
                    tsb.append("candidates", before);
                    tsb.append("remains", after);
                    tsb.append("unmanaged", unmanaged);
                    tsb.append("scavenged", scavenged);
                    logger.debug(tsb.toString());
                }
            }
        }
        catch (Exception e) {
            logger.warn("Failed to check expiration on [" + StringUtils.joinCommaDelimitedList(candidates) + "]", e);
        }
        long now = System.currentTimeMillis();
        try {
            if (now > this.lastOrphanSweepTime + scavengingInterval * 10L) {
                if (logger.isTraceEnabled()) {
                    logger.trace("Cleaning orphans at " + now + ", last sweep at " + this.lastOrphanSweepTime);
                }
                this.sessionCache.cleanOrphans(now - scavengingInterval * 10L);
            }
        }
        finally {
            this.lastOrphanSweepTime = now;
        }
    }

    @Override
    public void addSessionListener(SessionListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Register session listener " + String.valueOf(listener) + " in " + this.getComponentName());
        }
        this.sessionListeners.add(listener);
    }

    @Override
    public void removeSessionListener(SessionListener listener) {
        if (logger.isDebugEnabled()) {
            logger.debug("Remove session listener " + String.valueOf(listener) + " from " + this.getComponentName());
        }
        this.sessionListeners.remove(listener);
    }

    @Override
    public void clearSessionListeners() {
        this.sessionListeners.clear();
    }

    protected void onSessionAttributeUpdate(Session session, String name, Object oldValue, Object newValue) {
        if (session != null) {
            for (SessionListener listener : this.sessionListeners) {
                if (oldValue == null) {
                    listener.attributeAdded(session, name, newValue);
                    continue;
                }
                if (newValue == null) {
                    listener.attributeRemoved(session, name, oldValue);
                    continue;
                }
                listener.attributeUpdated(session, name, newValue, oldValue);
            }
        }
    }

    protected void onSessionDestroyed(Session session) {
        if (session != null && !this.sessionListeners.isEmpty()) {
            ArrayList<SessionListener> listeners = new ArrayList<SessionListener>(this.sessionListeners);
            ListIterator iter = listeners.listIterator(listeners.size());
            while (iter.hasPrevious()) {
                ((SessionListener)iter.previous()).sessionDestroyed(session);
            }
        }
    }

    protected void onSessionCreated(Session session) {
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionCreated(session);
        }
    }

    protected void onSessionEvicted(Session session) {
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionEvicted(session);
        }
    }

    protected void onSessionResided(Session session) {
        for (SessionListener listener : this.sessionListeners) {
            listener.sessionResided(session);
        }
    }

    @Override
    public Set<String> getActiveSessions() {
        return this.sessionCache.getActiveSessions();
    }

    @Override
    public Set<String> getAllSessions() {
        return this.sessionCache.getActiveSessions();
    }

    @Override
    public void recordSessionTime(@NonNull ManagedSession session) {
        long now = System.currentTimeMillis();
        this.getStatistics().recordTime(Math.round((double)(now - session.getSessionData().getCreated()) / 1000.0));
    }

    @Override
    public SessionStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    protected void doInitialize() throws Exception {
        AbstractComponent component;
        SessionCache sessionCache = this.sessionCache;
        if (sessionCache instanceof AbstractComponent && (component = (AbstractComponent)((Object)sessionCache)).isInitializable()) {
            component.initialize();
        }
        this.scheduler.start();
        if (this.houseKeeper != null && !this.houseKeeper.isRunning()) {
            this.houseKeeper.start();
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        if (this.houseKeeper != null) {
            this.houseKeeper.stop();
        }
        this.scheduler.stop();
        SessionCache sessionCache = this.sessionCache;
        if (sessionCache instanceof AbstractComponent) {
            AbstractComponent component = (AbstractComponent)((Object)sessionCache);
            component.destroy();
        }
    }

    @Override
    public String getComponentName() {
        if (this.getWorkerName() != null) {
            return super.getComponentName() + "(" + this.getWorkerName() + ")";
        }
        return super.getComponentName();
    }
}

