/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.AbstractComponent;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSessionStore
extends AbstractComponent
implements SessionStore {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionStore.class);
    public static final int DEFAULT_GRACE_PERIOD_SECS = 300;
    public static final int DEFAULT_SAVE_PERIOD_SECS = 0;
    private int gracePeriodSecs = 300;
    private int savePeriodSecs = 0;
    private Set<String> nonPersistentAttributes;
    private long lastExpiryCheckTime = 0L;

    public int getGracePeriodSecs() {
        return this.gracePeriodSecs;
    }

    public long getGracePeriodMillis(float weight) {
        if (this.gracePeriodSecs > 0) {
            return TimeUnit.SECONDS.toMillis((long)((float)this.gracePeriodSecs * weight));
        }
        return 0L;
    }

    public void setGracePeriodSecs(int gracePeriodSecs) {
        this.gracePeriodSecs = gracePeriodSecs;
    }

    public int getSavePeriodSecs() {
        return this.savePeriodSecs;
    }

    public long getSavePeriodMillis() {
        if (this.savePeriodSecs > 0) {
            return TimeUnit.SECONDS.toMillis(this.savePeriodSecs);
        }
        return 0L;
    }

    public void setSavePeriodSecs(int savePeriodSecs) {
        this.savePeriodSecs = savePeriodSecs;
    }

    @Override
    public Set<String> getNonPersistentAttributes() {
        return this.nonPersistentAttributes;
    }

    public void setNonPersistentAttributes(String ... nonPersistentAttributes) {
        this.checkInitializable();
        if (nonPersistentAttributes != null && nonPersistentAttributes.length > 0) {
            HashSet attrNames = new HashSet();
            Collections.addAll(attrNames, nonPersistentAttributes);
            this.nonPersistentAttributes = Collections.unmodifiableSet(attrNames);
        } else {
            this.nonPersistentAttributes = null;
        }
    }

    public boolean isNonPersistentAttribute(String attrName) {
        if (this.nonPersistentAttributes != null) {
            return this.nonPersistentAttributes.contains(attrName);
        }
        return false;
    }

    @Override
    public void save(String id, SessionData data) throws Exception {
        this.checkAvailable();
        if (data == null) {
            return;
        }
        long lastSaveMs = data.getLastSaved();
        long savePeriodMs = this.getSavePeriodMillis();
        if (logger.isTraceEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder("Store session");
            tsb.append("id", id);
            tsb.append("dirty", data.isDirty());
            tsb.append("lastSaved", data.getLastSaved());
            tsb.append("savePeriod", savePeriodMs);
            tsb.append("elapsed", System.currentTimeMillis() - lastSaveMs);
            logger.trace(tsb.toString());
        }
        if (data.isDirty() || lastSaveMs <= 0L || System.currentTimeMillis() - lastSaveMs > savePeriodMs) {
            data.setLastSaved(System.currentTimeMillis());
            try {
                this.doSave(id, data);
                data.setDirty(false);
            }
            catch (Exception e) {
                data.setLastSaved(lastSaveMs);
                throw e;
            }
        }
    }

    public abstract void doSave(String var1, SessionData var2) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getExpired(Set<String> candidates) {
        if (candidates == null) {
            throw new IllegalArgumentException("candidates must not be null");
        }
        this.checkAvailable();
        long now = System.currentTimeMillis();
        Set<String> expiredSessions = null;
        try {
            long time = 0L;
            if (this.lastExpiryCheckTime <= 0L) {
                time = now - this.getGracePeriodMillis(3.0f);
            } else {
                long gracePeriodMillis = this.getGracePeriodMillis(0.0f);
                if (now > this.lastExpiryCheckTime + gracePeriodMillis) {
                    time = now - gracePeriodMillis;
                }
            }
            if (time > 0L) {
                expiredSessions = this.doGetExpired(time);
                for (String id : candidates) {
                    if (expiredSessions.contains(id) || this.checkExpiry(id, time)) continue;
                    expiredSessions.add(id);
                }
            }
        }
        finally {
            this.lastExpiryCheckTime = now;
        }
        return expiredSessions;
    }

    private boolean checkExpiry(String id, long time) {
        SessionData data = null;
        try {
            data = this.load(id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.checkExpiry(data, time);
    }

    protected boolean checkExpiry(SessionData data, long time) {
        return data != null && (data.getExpiry() <= 0L || data.getExpiry() > time);
    }

    public abstract Set<String> doGetExpired(long var1);

    public abstract void doCleanOrphans(long var1);

    @Override
    public void cleanOrphans(long time) {
        this.checkAvailable();
        this.doCleanOrphans(time);
    }
}

