/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionCache;
import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.ManagedSession;
import com.aspectran.core.component.session.MaxSessionsExceededException;
import com.aspectran.core.component.session.NonPersistent;
import com.aspectran.core.component.session.NonPersistentValue;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public class DefaultSessionCache
extends AbstractSessionCache {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSessionCache.class);
    private final Map<String, ManagedSession> sessions = new ConcurrentHashMap<String, ManagedSession>();
    private volatile int maxActiveSessions;

    public DefaultSessionCache(AbstractSessionHandler sessionHandler, SessionStore sessionStore, boolean clusterEnabled) {
        super(sessionHandler, sessionStore, clusterEnabled);
    }

    @Override
    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    @Override
    public void setMaxActiveSessions(int maxActiveSessions) {
        this.maxActiveSessions = maxActiveSessions;
    }

    @Override
    protected ManagedSession doGet(String id) {
        return id != null ? this.sessions.get(id) : null;
    }

    @Override
    protected ManagedSession doPutIfAbsent(String id, ManagedSession session) {
        AtomicBoolean absent = new AtomicBoolean(false);
        ManagedSession current = this.doComputeIfAbsent(id, k -> {
            absent.set(true);
            return session;
        });
        return absent.get() ? null : current;
    }

    @Override
    protected ManagedSession doComputeIfAbsent(String id, Function<String, ManagedSession> mappingFunction) {
        return this.sessions.computeIfAbsent(id, k -> {
            this.checkMaxSessions(id);
            ManagedSession session = (ManagedSession)mappingFunction.apply((String)k);
            if (session != null) {
                this.getStatistics().sessionActivated();
            }
            return session;
        });
    }

    @Override
    protected ManagedSession doDelete(String id) {
        ManagedSession session = this.sessions.remove(id);
        if (session != null) {
            this.getStatistics().sessionInactivated();
        }
        return session;
    }

    private void checkMaxSessions(String id) {
        if (this.maxActiveSessions > 0 && this.getStatistics().getNumberOfActives() >= (long)this.maxActiveSessions) {
            this.getStatistics().sessionRejected();
            if (logger.isDebugEnabled()) {
                logger.debug("Reject session id=" + id + "; Exceeded maximum number of sessions allowed");
            }
            throw new MaxSessionsExceededException(id, this.maxActiveSessions);
        }
    }

    @Override
    public Set<String> getActiveSessions() {
        return new HashSet<String>(this.sessions.keySet());
    }

    @Override
    public Set<String> getAllSessions() {
        if (this.getSessionStore() != null) {
            return this.getSessionStore().getAllSessions();
        }
        return this.getActiveSessions();
    }

    @Override
    protected void doInitialize() throws Exception {
        if (this.getSessionStore() != null) {
            int restoredSessions;
            if (this.getSessionStore().isInitializable()) {
                this.getSessionStore().initialize();
            }
            if (!this.isClusterEnabled() && (restoredSessions = this.getSessionStore().getAllSessions().size()) > 0) {
                this.getStatistics().sessionCreated(restoredSessions);
                if (logger.isDebugEnabled()) {
                    logger.debug("Restored " + restoredSessions + " sessions from " + this.getSessionStoreName());
                }
            }
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        int loop = 100;
        while (!this.sessions.isEmpty() && loop-- >= 0) {
            for (ManagedSession session : this.sessions.values()) {
                if (this.getSessionStore() != null) {
                    if (this.getSessionStore().getNonPersistentAttributes() != null) {
                        for (String name : this.getSessionStore().getNonPersistentAttributes()) {
                            try {
                                session.removeAttribute(name);
                            }
                            catch (Exception e) {
                                logger.warn("Failed to remove non-persistent attribute: " + name, e);
                            }
                        }
                    }
                    try (AutoLock ignored = session.lock();){
                        for (Map.Entry<String, Object> entry : session.getSessionData().getAllAttributes().entrySet()) {
                            String name = entry.getKey();
                            Object value = entry.getValue();
                            if (!(value instanceof NonPersistent)) continue;
                            try {
                                Object old = session.getSessionData().removeAttribute(name);
                                if (old == null) continue;
                                Object oldValue = NonPersistentValue.unwrap(old);
                                session.onSessionAttributeUpdate(name, oldValue, null);
                            }
                            catch (Exception e) {
                                logger.warn("Failed to remove non-persistent attribute: " + name, e);
                            }
                        }
                    }
                    try {
                        this.getSessionStore().save(session.getId(), session.getSessionData());
                    }
                    catch (Exception e) {
                        logger.warn("Failed to save session data of session id=" + session.getId(), e);
                    }
                    this.doDelete(session.getId());
                    continue;
                }
                try {
                    session.invalidate();
                    session.setDestroyedReason(Session.DestroyedReason.UNDEPLOY);
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Session invalidation failed, but ignored", e);
                }
            }
        }
        if (this.getSessionStore() != null) {
            this.getSessionStore().destroy();
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("maxActiveSessions", this.getMaxActiveSessions());
        tsb.append("evictionIdleSecs", this.getEvictionIdleSecs());
        tsb.appendForce("saveOnCreate", this.isSaveOnCreate());
        tsb.appendForce("saveOnInactiveEviction", this.isSaveOnInactiveEviction());
        tsb.appendForce("clusterEnabled", this.isClusterEnabled());
        tsb.append("store", this.getSessionStoreName());
        return tsb.toString();
    }
}

