/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.DefaultSessionCache;
import com.aspectran.core.component.session.FileSessionStoreFactory;
import com.aspectran.core.component.session.HouseKeeper;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionIdGenerator;
import com.aspectran.core.component.session.SessionManager;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.config.SessionFileStoreConfig;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.ScheduledExecutorScheduler;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultSessionManager
extends AbstractSessionHandler
implements SessionManager,
ActivityContextAware,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSessionManager.class);
    private static final String UNNAMED_WORKER_PREFIX = "unnamed";
    private static final AtomicInteger uniqueNumberIssuer = new AtomicInteger();
    private ApplicationAdapter applicationAdapter;
    private ClassLoader classLoader;
    private SessionManagerConfig sessionManagerConfig;
    private SessionStore sessionStore;

    public DefaultSessionManager() {
    }

    public DefaultSessionManager(String workerName) {
        this.setWorkerName(workerName);
    }

    @Override
    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.checkInitializable();
        this.applicationAdapter = context.getApplicationAdapter();
        this.classLoader = context.getClassLoader();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.checkInitializable();
        this.classLoader = classLoader;
    }

    public ApplicationAdapter getApplicationAdapter() {
        return this.applicationAdapter;
    }

    public SessionManagerConfig getSessionManagerConfig() {
        return this.sessionManagerConfig;
    }

    public void setSessionManagerConfig(SessionManagerConfig sessionManagerConfig) {
        this.checkInitializable();
        this.sessionManagerConfig = sessionManagerConfig;
    }

    public void setSessionManagerConfigWithApon(String apon) {
        SessionManagerConfig sessionManagerConfig = new SessionManagerConfig();
        try {
            sessionManagerConfig.readFrom(apon);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionStore(SessionStore sessionStore) {
        this.checkInitializable();
        this.sessionStore = sessionStore;
    }

    @Override
    public SessionHandler getSessionHandler() {
        this.checkAvailable();
        return this;
    }

    @Override
    protected void doInitialize() throws Exception {
        boolean clusterEnabled = false;
        int scavengingIntervalSeconds = -1;
        if (this.sessionManagerConfig == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing " + this.getComponentName());
            }
            this.setWorkerName(UNNAMED_WORKER_PREFIX + uniqueNumberIssuer.getAndIncrement());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Initializing " + ToStringBuilder.toString(this.getComponentName(), this.sessionManagerConfig));
            }
            if (this.sessionManagerConfig.isClusterEnabled()) {
                clusterEnabled = true;
            }
            if (this.sessionManagerConfig.hasWorkerName()) {
                uniqueNumberIssuer.getAndIncrement();
                this.setWorkerName(this.sessionManagerConfig.getWorkerName());
            } else {
                this.setWorkerName(UNNAMED_WORKER_PREFIX + uniqueNumberIssuer.getAndIncrement());
            }
            if (this.sessionManagerConfig.hasMaxIdleSeconds()) {
                this.setDefaultMaxIdleSecs(this.sessionManagerConfig.getMaxIdleSeconds());
            }
            scavengingIntervalSeconds = this.sessionManagerConfig.hasScavengingIntervalSeconds() ? this.sessionManagerConfig.getScavengingIntervalSeconds() : 0;
        }
        if (this.getScheduler() == null) {
            Object schedulerName = this.getWorkerName() != null ? "SM worker-" + this.getWorkerName() : String.format("SM worker@%x", this.hashCode());
            ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler((String)schedulerName, false);
            this.setScheduler(scheduler);
        }
        if (scavengingIntervalSeconds > -1) {
            HouseKeeper houseKeeper = new HouseKeeper(this, scavengingIntervalSeconds);
            this.setHouseKeeper(houseKeeper);
        }
        if (this.getSessionIdGenerator() == null) {
            SessionIdGenerator sessionIdGenerator = new SessionIdGenerator(this.getWorkerName());
            this.setSessionIdGenerator(sessionIdGenerator);
        }
        if (this.getSessionCache() == null) {
            SessionFileStoreConfig fileStoreConfig;
            if (this.sessionStore == null && this.sessionManagerConfig != null && (fileStoreConfig = this.sessionManagerConfig.getFileStoreConfig()) != null) {
                FileSessionStoreFactory fileSessionStoreFactory = new FileSessionStoreFactory();
                fileSessionStoreFactory.setApplicationAdapter(this.getApplicationAdapter());
                String storeDir = fileStoreConfig.getStoreDir();
                if (StringUtils.hasText(storeDir)) {
                    fileSessionStoreFactory.setStoreDir(storeDir);
                }
                if (fileStoreConfig.hasGracePeriodSeconds()) {
                    fileSessionStoreFactory.setGracePeriodSecs(fileStoreConfig.getGracePeriodSeconds());
                }
                if (fileStoreConfig.hasSavePeriodSeconds()) {
                    fileSessionStoreFactory.setSavePeriodSecs(fileStoreConfig.getSavePeriodSeconds());
                }
                if (fileStoreConfig.hasDeleteUnrestorableFiles()) {
                    fileSessionStoreFactory.setDeleteUnrestorableFiles(fileStoreConfig.isDeleteUnrestorableFiles());
                }
                if (fileStoreConfig.hasNonPersistentAttributes()) {
                    fileSessionStoreFactory.setNonPersistentAttributes(fileStoreConfig.getNonPersistentAttributes());
                }
                this.sessionStore = fileSessionStoreFactory.createSessionStore();
            }
            DefaultSessionCache sessionCache = new DefaultSessionCache(this, this.sessionStore, clusterEnabled);
            if (this.sessionManagerConfig != null) {
                if (this.sessionManagerConfig.hasMaxActiveSessions()) {
                    int maxActiveSessions = this.sessionManagerConfig.getMaxActiveSessions();
                    sessionCache.setMaxActiveSessions(maxActiveSessions);
                }
                if (this.sessionManagerConfig.hasEvictionIdleSeconds()) {
                    int secs = this.sessionManagerConfig.getEvictionIdleSeconds();
                    if (this.sessionStore == null && secs != -1) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Fixed to evictionIdleSeconds=-1 because there is no session store");
                        }
                        secs = -1;
                    }
                    sessionCache.setEvictionIdleSecs(secs);
                }
                if (this.sessionManagerConfig.hasSaveOnCreate()) {
                    boolean saveOnCreate = this.sessionManagerConfig.getSaveOnCreate();
                    if (this.sessionStore == null && saveOnCreate) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Fixed to saveOnCreate=false because there is no session store");
                        }
                        saveOnCreate = false;
                    }
                    sessionCache.setSaveOnCreate(saveOnCreate);
                }
                if (this.sessionManagerConfig.hasSaveOnInactiveEviction()) {
                    boolean saveOnInactiveEviction = this.sessionManagerConfig.getSaveOnInactiveEviction();
                    if (this.sessionStore == null && saveOnInactiveEviction) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Fixed to saveOnInactiveEviction=false because there is no session store");
                        }
                        saveOnInactiveEviction = false;
                    }
                    sessionCache.setSaveOnInactiveEviction(saveOnInactiveEviction);
                }
                if (this.sessionManagerConfig.hasRemoveUnloadableSessions()) {
                    boolean removeUnloadableSessions = this.sessionManagerConfig.getRemoveUnloadableSessions();
                    if (this.sessionStore == null && removeUnloadableSessions) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Fixed to removeUnloadableSessions=false because there is no session store");
                        }
                        removeUnloadableSessions = false;
                    }
                    sessionCache.setRemoveUnloadableSessions(removeUnloadableSessions);
                } else if (this.sessionStore != null) {
                    sessionCache.setRemoveUnloadableSessions(true);
                }
            }
            this.setSessionCache(sessionCache);
        }
        super.doInitialize();
    }
}

