/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionStoreFactory;
import com.aspectran.core.component.session.FileSessionStore;
import com.aspectran.utils.SystemUtils;
import java.io.File;
import java.io.IOException;

public class FileSessionStoreFactory
extends AbstractSessionStoreFactory {
    private String storeDir;
    private boolean deleteUnrestorableFiles = true;

    public String getStoreDir() {
        return this.storeDir;
    }

    public void setStoreDir(String storeDir) {
        this.storeDir = storeDir;
    }

    public boolean isDeleteUnrestorableFiles() {
        return this.deleteUnrestorableFiles;
    }

    public void setDeleteUnrestorableFiles(boolean deleteUnrestorableFiles) {
        this.deleteUnrestorableFiles = deleteUnrestorableFiles;
    }

    @Override
    public FileSessionStore createSessionStore() throws IOException {
        File storeDir = this.getStoreDir() != null ? (this.getApplicationAdapter() != null ? this.getApplicationAdapter().toRealPathAsFile(this.getStoreDir()) : new File(this.getStoreDir())) : new File(SystemUtils.getJavaIoTmpDir());
        FileSessionStore sessionStore = new FileSessionStore(storeDir);
        sessionStore.setDeleteUnrestorableFiles(this.isDeleteUnrestorableFiles());
        sessionStore.setGracePeriodSecs(this.getGracePeriodSecs());
        sessionStore.setSavePeriodSecs(this.getSavePeriodSecs());
        if (this.getNonPersistentAttributes() != null && this.getNonPersistentAttributes().length > 0) {
            sessionStore.setNonPersistentAttributes(this.getNonPersistentAttributes());
        }
        return sessionStore;
    }
}

