/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.lifecycle.AbstractLifeCycle;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;
import com.aspectran.utils.thread.Scheduler;
import com.aspectran.utils.thread.ThreadContextHelper;
import java.util.concurrent.TimeUnit;

public class HouseKeeper
extends AbstractLifeCycle {
    private static final Logger logger = LoggerFactory.getLogger(HouseKeeper.class);
    public static final int DEFAULT_SCAVENGING_INTERVAL = 600;
    private final AutoLock lock = new AutoLock();
    private final AbstractSessionHandler sessionHandler;
    private final Scheduler scheduler;
    private long scavengingInterval;
    private Scheduler.Task task;
    private Runner runner;

    public HouseKeeper(@NonNull AbstractSessionHandler sessionHandler) {
        this(sessionHandler, 600);
    }

    public HouseKeeper(@NonNull AbstractSessionHandler sessionHandler, int scavengingIntervalInSecs) {
        this.sessionHandler = sessionHandler;
        this.scheduler = sessionHandler.getScheduler();
        this.scavengingInterval = (long)scavengingIntervalInSecs * 1000L;
    }

    public int getScavengingInterval() {
        return (int)(this.scavengingInterval / 1000L);
    }

    public void setScavengingInterval(int intervalInSecs) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.isStarted() || this.isStarting()) {
                if (intervalInSecs <= 0) {
                    this.scavengingInterval = 0L;
                    logger.info(this.sessionHandler.getComponentName() + " scavenging disabled");
                    this.stopScavenging();
                } else {
                    if (intervalInSecs < 10) {
                        logger.warn("Short interval of " + intervalInSecs + " secs for session scavenging");
                    }
                    this.scavengingInterval = (long)intervalInSecs * 1000L;
                    this.startScavenging();
                }
            } else {
                this.scavengingInterval = (long)intervalInSecs * 1000L;
            }
        }
    }

    protected void startScavenging() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.task != null) {
                this.task.cancel();
            }
            if (this.runner != null) {
                this.runner.stop();
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this) + " is scavenging every " + this.scavengingInterval + " ms");
            }
            this.runner = new Runner();
            this.task = this.scheduler.schedule(this.runner, this.scavengingInterval, TimeUnit.MILLISECONDS, true);
        }
    }

    protected void stopScavenging() {
        try (AutoLock ignored = this.lock.lock();){
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
            if (this.runner != null) {
                this.runner.stop();
                this.runner = null;
            }
        }
    }

    private void scavenge() {
        if (this.isStopping() || this.isStopped()) {
            return;
        }
        ThreadContextHelper.run(this.sessionHandler.getClassLoader(), () -> {
            try {
                this.sessionHandler.scavenge(this.scavengingInterval);
            }
            catch (Exception e) {
                logger.warn(e);
            }
        });
    }

    @Override
    protected void doStart() throws Exception {
        this.setScavengingInterval(this.getScavengingInterval());
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.stopScavenging();
        super.doStop();
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() && this.scavengingInterval > 0L;
    }

    @Override
    public String toString() {
        if (this.isStopped()) {
            ToStringBuilder tsb = new ToStringBuilder(super.toString());
            tsb.append("scavengingInterval", this.scavengingInterval);
            return String.valueOf(tsb) + " used by " + this.sessionHandler.getComponentName();
        }
        return super.toString();
    }

    private class Runner
    implements Runnable {
        private volatile boolean running = true;

        private Runner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.running) {
                try {
                    HouseKeeper.this.scavenge();
                }
                finally {
                    try (AutoLock ignored = HouseKeeper.this.lock.lock();){
                        if (HouseKeeper.this.scheduler != null && HouseKeeper.this.scheduler.isRunning()) {
                            if (HouseKeeper.this.task != null) {
                                HouseKeeper.this.task.cancel();
                            }
                            HouseKeeper.this.task = HouseKeeper.this.scheduler.schedule(this, HouseKeeper.this.scavengingInterval, TimeUnit.MILLISECONDS, true);
                        }
                    }
                }
            }
        }

        public void stop() {
            this.running = false;
        }
    }
}

