/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.AbstractSessionHandler;
import com.aspectran.core.component.session.NonPersistentValue;
import com.aspectran.core.component.session.Session;
import com.aspectran.core.component.session.SessionBindingListener;
import com.aspectran.core.component.session.SessionData;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionInactivityTimer;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.AutoLock;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ManagedSession
implements Session {
    private static final Logger logger = LoggerFactory.getLogger(ManagedSession.class);
    private final AutoLock autoLock = new AutoLock();
    private final AbstractSessionHandler sessionHandler;
    private final SessionInactivityTimer sessionInactivityTimer;
    private SessionData sessionData;
    private boolean newSession;
    private boolean resident;
    private int requests;
    private State state = State.VALID;
    private Session.DestroyedReason destroyedReason;

    protected ManagedSession(AbstractSessionHandler sessionHandler, SessionData sessionData, boolean newSession) {
        this.sessionHandler = sessionHandler;
        this.sessionInactivityTimer = new SessionInactivityTimer(sessionHandler, this);
        this.sessionData = sessionData;
        this.newSession = newSession;
        if (newSession) {
            this.sessionData.setDirty(true);
            this.requests = 1;
        }
    }

    public SessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    protected SessionData getSessionData() {
        return this.sessionData;
    }

    protected void setSessionData(SessionData sessionData) {
        this.sessionData = sessionData;
    }

    @Override
    public String getId() {
        try (AutoLock ignored = this.autoLock.lock();){
            String string = this.sessionData.getId();
            return string;
        }
    }

    @Override
    public <T> T getAttribute(String name) {
        try (AutoLock ignored = this.autoLock.lock();){
            this.checkValidForRead();
            Object t = NonPersistentValue.unwrap(this.sessionData.getAttribute(name));
            return t;
        }
    }

    @Override
    public Set<String> getAttributeNames() {
        try (AutoLock ignored = this.autoLock.lock();){
            this.checkValidForRead();
            Set<String> set = this.sessionData.getKeys();
            return set;
        }
    }

    @Override
    public Object setAttribute(String name, Object value) {
        try (AutoLock ignored = this.autoLock.lock();){
            this.checkValidForWrite();
            Object old = this.sessionData.setAttribute(name, value);
            if (value == null && old == null) {
                Object var5_6 = null;
                return var5_6;
            }
            Object newValue = NonPersistentValue.unwrap(value);
            Object oldValue = NonPersistentValue.unwrap(old);
            this.onSessionAttributeUpdate(name, oldValue, newValue);
            Object t = oldValue;
            return t;
        }
    }

    @Override
    public Object removeAttribute(String name) {
        return this.setAttribute(name, null);
    }

    @Override
    public long getCreationTime() {
        try (AutoLock ignored = this.autoLock.lock();){
            this.checkValidForRead();
            long l = this.sessionData.getCreated();
            return l;
        }
    }

    @Override
    public long getLastAccessedTime() {
        try (AutoLock ignored = this.autoLock.lock();){
            long l = this.sessionData.getLastAccessed();
            return l;
        }
    }

    @Override
    public int getMaxInactiveInterval() {
        try (AutoLock ignored = this.autoLock.lock();){
            if (this.sessionData.getInactiveInterval() > 0L) {
                int n = (int)(this.sessionData.getInactiveInterval() / 1000L);
                return n;
            }
            int n = -1;
            return n;
        }
    }

    @Override
    public void setMaxInactiveInterval(int secs) {
        try (AutoLock ignored = this.autoLock.lock();){
            this.sessionData.setInactiveInterval((long)secs * 1000L);
            this.sessionData.calcAndSetExpiry();
            this.sessionData.setDirty(true);
            if (logger.isDebugEnabled()) {
                if (secs <= 0) {
                    logger.debug("Session " + this.sessionData.getId() + " is now immortal (maxInactiveInterval=" + secs + ")");
                } else {
                    logger.debug("Session " + this.sessionData.getId() + " maxInactiveInterval=" + secs);
                }
            }
        }
    }

    @Override
    public boolean access() {
        try (AutoLock ignored = this.autoLock.lock();){
            if (this.state != State.VALID) {
                boolean bl = false;
                return bl;
            }
            this.newSession = false;
            long now = System.currentTimeMillis();
            this.sessionData.setAccessed(now);
            this.sessionData.calcAndSetExpiry(now);
            if (this.isExpiredAt(now)) {
                this.invalidate();
                boolean bl = false;
                return bl;
            }
            if (this.requests == 0) {
                this.sessionHandler.refreshSession(this);
            }
            ++this.requests;
            if (logger.isDebugEnabled()) {
                logger.debug("Session " + this.getId() + " accessed, stopping timer, active requests=" + this.requests);
            }
            this.sessionInactivityTimer.cancel();
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void complete() {
        try (AutoLock ignored = this.autoLock.lock();){
            --this.requests;
            if (this.requests < 0) {
                int temp = this.requests;
                this.requests = 0;
                throw new IllegalStateException("Incomplete session transaction; requests=" + temp);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Session " + this.getId() + " complete, active requests=" + this.requests);
            }
            if (this.requests == 0) {
                long now = System.currentTimeMillis();
                this.sessionData.calcAndSetExpiry(now);
                this.sessionData.setLastAccessed(this.sessionData.getAccessed());
                this.sessionHandler.releaseSession(this);
                this.sessionInactivityTimer.schedule(this.calculateInactivityTimeout(now));
            }
        }
    }

    protected long getRequests() {
        try (AutoLock ignored = this.autoLock.lock();){
            long l = this.requests;
            return l;
        }
    }

    protected long calculateInactivityTimeout(long now) {
        long time;
        try (AutoLock ignored = this.autoLock.lock();){
            long remaining = this.sessionData.getExpiry() - now;
            long maxInactive = this.sessionData.getInactiveInterval();
            int evictionIdleSecs = this.sessionHandler.getSessionCache().getEvictionIdleSecs();
            if (maxInactive <= 0L) {
                if (evictionIdleSecs < 1) {
                    time = -1L;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Session " + this.getId() + " is immortal && no inactivity eviction");
                    }
                } else {
                    time = TimeUnit.SECONDS.toMillis(evictionIdleSecs);
                    if (logger.isTraceEnabled()) {
                        logger.trace("Session " + this.getId() + " is immortal; evict after " + evictionIdleSecs + " sec inactivity");
                    }
                }
            } else if (evictionIdleSecs == -1) {
                time = Math.max(remaining, 0L);
                if (logger.isTraceEnabled()) {
                    logger.trace("Session " + this.getId() + " no eviction");
                }
            } else if (evictionIdleSecs == 0) {
                time = -1L;
                if (logger.isTraceEnabled()) {
                    logger.trace("Session " + this.getId() + " evict on exit");
                }
            } else {
                long l = time = remaining > 0L ? Math.min(maxInactive, TimeUnit.SECONDS.toMillis(evictionIdleSecs)) : 0L;
                if (logger.isTraceEnabled()) {
                    logger.trace("Session " + this.getId() + " timer set to lesser of maxIdleSeconds=" + maxInactive / 1000L + " and evictionIdleSeconds=" + evictionIdleSecs);
                }
            }
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        boolean result = this.beginInvalidate();
        if (result) {
            try {
                try (AutoLock ignored = this.autoLock.lock();){
                    if (this.getDestroyedReason() == null) {
                        this.setDestroyedReason(Session.DestroyedReason.INVALIDATED);
                    }
                    this.sessionHandler.onSessionDestroyed(this);
                }
                catch (Exception e) {
                    logger.warn("Error during Session destroy listener", e);
                }
                finally {
                    this.finishInvalidate();
                    this.sessionHandler.removeSession(this.sessionData.getId(), false);
                }
            }
            catch (Exception e) {
                logger.warn("Unable to invalidate session " + String.valueOf(this), e);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean beginInvalidate() {
        boolean result = false;
        try (AutoLock ignored = this.autoLock.lock();){
            switch (this.state.ordinal()) {
                case 1: {
                    throw new IllegalStateException();
                }
                case 2: {
                    if (!logger.isDebugEnabled()) return result;
                    logger.debug("Session " + this.sessionData.getId() + " already being invalidated");
                    return result;
                }
                case 0: {
                    this.state = State.INVALIDATING;
                    result = true;
                    return result;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finishInvalidate() {
        try (AutoLock ignored = this.autoLock.lock();){
            try {
                if (this.state == State.VALID || this.state == State.INVALIDATING) {
                    Set<String> keys;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Invalidate session id=" + this.sessionData.getId());
                    }
                    do {
                        keys = this.sessionData.getKeys();
                        for (String key : keys) {
                            Object old = this.sessionData.setAttribute(key, null);
                            if (old == null) continue;
                            this.onSessionAttributeUpdate(key, old, null);
                        }
                    } while (!keys.isEmpty());
                }
            }
            finally {
                this.state = State.INVALID;
                this.sessionHandler.getStatistics().sessionExpired();
                this.sessionHandler.recordSessionTime(this);
            }
        }
    }

    @Override
    public Session.DestroyedReason getDestroyedReason() {
        return this.destroyedReason;
    }

    protected void setDestroyedReason(Session.DestroyedReason destroyedReason) {
        this.destroyedReason = destroyedReason;
    }

    @Override
    public boolean isValid() {
        try (AutoLock ignored = this.autoLock.lock();){
            boolean bl = this.state == State.VALID;
            return bl;
        }
    }

    @Override
    public boolean isNew() {
        try (AutoLock ignored = this.autoLock.lock();){
            this.checkValidForRead();
            boolean bl = this.newSession;
            return bl;
        }
    }

    protected boolean isResident() {
        return this.resident;
    }

    protected void setResident(boolean resident) {
        this.resident = resident;
        if (!resident) {
            this.sessionInactivityTimer.destroy();
        }
    }

    protected boolean isExpiredAt(long time) {
        try (AutoLock ignored = this.autoLock.lock();){
            this.checkValidForRead();
            boolean bl = this.sessionData.isExpiredAt(time);
            return bl;
        }
    }

    protected boolean isIdleLongerThan(int sec) {
        long now = System.currentTimeMillis();
        try (AutoLock ignored = this.autoLock.lock();){
            boolean bl = this.sessionData.getAccessed() + (long)sec * 1000L <= now;
            return bl;
        }
    }

    protected void onSessionAttributeUpdate(String name, Object oldValue, Object newValue) {
        if (newValue == null || !newValue.equals(oldValue)) {
            if (oldValue != null) {
                this.unbindValue(name, oldValue);
            }
            if (newValue != null) {
                this.bindValue(name, newValue);
            }
        }
        this.sessionHandler.onSessionAttributeUpdate(this, name, oldValue, newValue);
    }

    protected void unbindValue(String name, Object value) {
        if (value instanceof SessionBindingListener) {
            SessionBindingListener listener = (SessionBindingListener)value;
            listener.valueUnbound(this, name, value);
        }
    }

    protected void bindValue(String name, Object value) {
        if (value instanceof SessionBindingListener) {
            SessionBindingListener listener = (SessionBindingListener)value;
            listener.valueBound(this, name, value);
        }
    }

    protected void checkValidForWrite() {
        if (this.state == State.INVALID) {
            throw new IllegalStateException("Not valid for write: session " + String.valueOf(this));
        }
        if (this.state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Not valid for write: session " + String.valueOf(this));
        }
    }

    protected void checkValidForRead() {
        if (this.state == State.INVALID) {
            throw new IllegalStateException("Invalid for read: session " + String.valueOf(this));
        }
        if (this.state == State.INVALIDATING) {
            return;
        }
        if (!this.isResident()) {
            throw new IllegalStateException("Invalid for read: id=" + this.sessionData.getId() + " not resident");
        }
    }

    protected AutoLock lock() {
        return this.autoLock.lock();
    }

    public String toString() {
        try (AutoLock ignored = this.autoLock.lock();){
            ToStringBuilder tsb = new ToStringBuilder(this.getClass().getSimpleName() + "@" + this.hashCode());
            tsb.append("id", this.sessionData.getId());
            tsb.append("state", (Object)this.state);
            tsb.append("requests", this.requests);
            tsb.appendForce("resident", this.resident);
            String string = tsb.toString();
            return string;
        }
    }

    private static enum State {
        VALID,
        INVALID,
        INVALIDATING;

    }
}

