/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.core.component.session;

import com.aspectran.core.component.session.NonPersistent;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class NonPersistentValue
implements NonPersistent {
    private final Object value;

    public NonPersistentValue(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public static <T> T unwrap(T value) {
        if (value instanceof NonPersistentValue) {
            NonPersistentValue nonPersistentValue = (NonPersistentValue)value;
            return (T)nonPersistentValue.getValue();
        }
        return value;
    }

    @NonNull
    public static NonPersistentValue wrap(Object value) {
        Assert.notNull(value, "value must not be null");
        return new NonPersistentValue(value);
    }
}

